/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;
import jebl.util.AttributableHelper;

public class CodonSequence
implements Sequence {
    private AttributableHelper helper = null;
    private final Taxon taxon;
    private final SequenceType sequenceType = SequenceType.CODON;
    private final State[] sequenceStates;

    public CodonSequence(Taxon taxon, State[] states) {
        this.taxon = taxon;
        this.sequenceStates = new CodonState[states.length];
        for (int i = 0; i < states.length; ++i) {
            this.sequenceStates[i] = states[i];
        }
    }

    @Override
    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public String getString() {
        StringBuilder buffer = new StringBuilder(this.sequenceStates.length);
        for (State state : this.sequenceStates) {
            buffer.append(state.getCode());
        }
        return buffer.toString();
    }

    public String getCleanString() {
        StringBuilder buffer = new StringBuilder(this.sequenceStates.length);
        for (State state : this.sequenceStates) {
            if (state.isAmbiguous() || state.isGap()) continue;
            buffer.append(state.getCode());
        }
        return buffer.toString();
    }

    @Override
    public State[] getStates() {
        return this.sequenceType.toStateArray(this.getStateIndices());
    }

    @Override
    public byte[] getStateIndices() {
        byte[] results = new byte[this.sequenceStates.length];
        for (int i = 0; i < this.sequenceStates.length; ++i) {
            results[i] = (byte)this.getState(i).getIndex();
        }
        return results;
    }

    public byte[] getSequenceCharacters() {
        throw new UnsupportedOperationException("codons don't have single character codes");
    }

    @Override
    public State getState(int site) {
        return this.sequenceStates[site];
    }

    @Override
    public int getLength() {
        return this.sequenceStates.length;
    }

    @Override
    public Taxon getTaxon() {
        return this.taxon;
    }

    public int compareTo(Object o) {
        return this.taxon.compareTo(((Sequence)o).getTaxon());
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodonSequence that = (CodonSequence)o;
        if (!Arrays.equals(this.sequenceStates, that.sequenceStates)) {
            return false;
        }
        if (this.sequenceType != null ? !this.sequenceType.equals(that.sequenceType) : that.sequenceType != null) {
            return false;
        }
        return !(this.taxon != null ? !this.taxon.equals(that.taxon) : that.taxon != null);
    }

    public int hashCode() {
        int result = this.taxon != null ? this.taxon.hashCode() : 0;
        result = 31 * result + (this.sequenceType != null ? this.sequenceType.hashCode() : 0);
        result = 31 * result + (this.sequenceStates != null ? Arrays.hashCode(this.sequenceStates) : 0);
        return result;
    }
}

