/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;

public final class Codons {
    public static final String NAME = "codon";
    public static final int CANONICAL_STATE_COUNT = 64;
    public static final int STATE_COUNT = 66;
    public static final CodonState[] CANONICAL_STATES;
    public static final CodonState[] STATES;
    public static final CodonState UNKNOWN_STATE;
    public static final CodonState GAP_STATE;
    private static final Map<String, CodonState> statesByCode;

    public static int getStateCount() {
        return 66;
    }

    public static List<State> getStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])STATES));
    }

    public static int getCanonicalStateCount() {
        return 64;
    }

    public static List<State> getCanonicalStates() {
        return Collections.unmodifiableList(Arrays.asList((State[])CANONICAL_STATES));
    }

    public static CodonState getState(NucleotideState nucleotide1, NucleotideState nucleotide2, NucleotideState nucleotide3) {
        if (nucleotide1.isGap() && nucleotide2.isGap() && nucleotide3.isGap()) {
            return GAP_STATE;
        }
        if (nucleotide1.isAmbiguous() || nucleotide2.isAmbiguous() || nucleotide3.isAmbiguous()) {
            return UNKNOWN_STATE;
        }
        String code = nucleotide1.getCode() + nucleotide2.getCode() + nucleotide3.getCode();
        return statesByCode.get(code);
    }

    public static CodonState getState(String code) {
        code = code.toUpperCase().replace('U', 'T');
        return statesByCode.get(code);
    }

    public static CodonState getState(int index) {
        return STATES[index];
    }

    public static CodonState getUnknownState() {
        return UNKNOWN_STATE;
    }

    public static CodonState getGapState() {
        return GAP_STATE;
    }

    public static boolean isUnknown(CodonState state) {
        return state == UNKNOWN_STATE;
    }

    public static boolean isGap(CodonState state) {
        return state == GAP_STATE;
    }

    public static NucleotideState[] toNucleotides(State[] states) {
        NucleotideState[] nucs = new NucleotideState[states.length * 3];
        int i = 0;
        for (State state : states) {
            System.arraycopy(Codons.toNucleotides((CodonState)state), 0, nucs, i, 3);
            i += 3;
        }
        return nucs;
    }

    public static NucleotideState[] toNucleotides(CodonState state) {
        NucleotideState[] nucs = new NucleotideState[3];
        String code = state.getCode();
        nucs[0] = Nucleotides.getState(code.charAt(0));
        nucs[1] = Nucleotides.getState(code.charAt(1));
        nucs[2] = Nucleotides.getState(code.charAt(2));
        return nucs;
    }

    public static CodonState[] toStateArray(String sequenceString) {
        int n = sequenceString.length() / 3;
        CodonState[] seq = new CodonState[n];
        for (int i = 0; i < n; ++i) {
            seq[i] = Codons.getState(sequenceString.substring(i * 3, i * 3 + 3));
        }
        return seq;
    }

    public static CodonState[] toStateArray(byte[] indexArray) {
        CodonState[] seq = new CodonState[indexArray.length];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = Codons.getState(indexArray[i]);
        }
        return seq;
    }

    static {
        int i;
        CANONICAL_STATES = new CodonState[64];
        char[] nucs = new char[]{'A', 'C', 'G', 'T'};
        int x = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    String code = "" + nucs[i2] + nucs[j] + nucs[k];
                    Codons.CANONICAL_STATES[x] = new CodonState(code, code, x);
                    ++x;
                }
            }
        }
        UNKNOWN_STATE = new CodonState("?", "???", 64, CANONICAL_STATES);
        GAP_STATE = new CodonState("-", "---", 65, CANONICAL_STATES);
        STATES = new CodonState[66];
        for (i = 0; i < 64; ++i) {
            Codons.STATES[i] = CANONICAL_STATES[i];
        }
        Codons.STATES[64] = UNKNOWN_STATE;
        Codons.STATES[65] = GAP_STATE;
        statesByCode = new HashMap<String, CodonState>();
        for (i = 0; i < STATES.length; ++i) {
            statesByCode.put(STATES[i].getCode(), STATES[i]);
        }
    }
}

