/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;

public final class NucleotideState
extends State {
    public final byte bitCode;

    NucleotideState(String name, String stateCode, int index, byte bitCode) {
        super(name, stateCode, index);
        this.bitCode = bitCode;
    }

    NucleotideState(String name, String stateCode, int index, byte bitCode, NucleotideState[] ambiguities) {
        super(name, stateCode, index, ambiguities);
        this.bitCode = bitCode;
    }

    @Override
    public int compareTo(Object o) {
        NucleotideState that = (NucleotideState)o;
        return super.compareTo(that);
    }

    @Override
    public boolean possiblyEqual(State other) {
        return (this.bitCode & ((NucleotideState)other).bitCode) > 0;
    }

    @Override
    public boolean isGap() {
        return this == Nucleotides.GAP_STATE;
    }

    @Override
    public SequenceType getType() {
        return SequenceType.NUCLEOTIDE;
    }
}

