/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.List;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.sequences.Utils;
import jebl.evolution.taxa.Taxon;
import jebl.util.Attributable;

public interface Sequence
extends Attributable,
Comparable {
    public Taxon getTaxon();

    public SequenceType getSequenceType();

    public String getString();

    public State[] getStates();

    public byte[] getStateIndices();

    public State getState(int var1);

    public int getLength();

    public static Sequence appendSequences(Sequence sequence1, Sequence sequence2) {
        if (sequence1.getSequenceType() != sequence2.getSequenceType()) {
            throw new IllegalArgumentException("sequences to be appended not of the same type");
        }
        State[] states = new State[sequence1.getLength() + sequence2.getLength()];
        System.arraycopy(sequence1.getStates(), 0, states, 0, sequence1.getLength());
        System.arraycopy(sequence2.getStates(), 0, states, sequence1.getLength(), sequence2.getLength());
        return new BasicSequence(sequence1.getSequenceType(), sequence1.getTaxon(), states);
    }

    public static Sequence getSubSequence(Sequence sequence, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("subsequence from is greater than to");
        }
        if (from >= sequence.getLength() || to >= sequence.getLength()) {
            throw new IllegalArgumentException("subsequence range out of bounds");
        }
        State[] states = new State[to - from + 1];
        System.arraycopy(sequence.getStates(), from, states, 0, states.length);
        return new BasicSequence(sequence.getSequenceType(), sequence.getTaxon(), states);
    }

    public static Sequence trimSequence(Sequence sequence, List<State> trimStates) {
        int i;
        State[] sourceStates = sequence.getStates();
        for (i = 0; i < sourceStates.length && trimStates.contains(sourceStates[i]); ++i) {
        }
        if (i < sourceStates.length) {
            Sequence sequence1 = Sequence.getSubSequence(sequence, i, sourceStates.length - 1);
            sourceStates = sequence1.getStates();
            for (i = sourceStates.length - 1; i > 0 && trimStates.contains(sourceStates[i]); --i) {
            }
            return Sequence.getSubSequence(sequence1, 0, i);
        }
        return new BasicSequence(sequence.getSequenceType(), sequence.getTaxon(), new State[0]);
    }

    public static Sequence stripGaps(Sequence sequence) {
        return new BasicSequence(sequence.getSequenceType(), sequence.getTaxon(), Utils.stripGaps(sequence.getStates()));
    }

    public static Sequence stripStates(Sequence sequence, List<State> stripStates) {
        return new BasicSequence(sequence.getSequenceType(), sequence.getTaxon(), Utils.stripStates(sequence.getStates(), stripStates));
    }

    public static Sequence replaceStates(Sequence sequence, List<State> searchStates, State replaceState) {
        return new BasicSequence(sequence.getSequenceType(), sequence.getTaxon(), Utils.replaceStates(sequence.getStates(), searchStates, replaceState));
    }

    public static int getStateCount(Sequence sequence, State state) {
        int count = 0;
        for (State s : sequence.getStates()) {
            if (!s.equals(state)) continue;
            ++count;
        }
        return count;
    }
}

