/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import jebl.evolution.sequences.FilteredSequence;
import jebl.evolution.sequences.GeneticCode;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.sequences.Utils;

public class TranslatedSequence
extends FilteredSequence {
    private final GeneticCode geneticCode;
    private final int frame;

    public TranslatedSequence(Sequence source, GeneticCode geneticCode) {
        this(source, geneticCode, 1);
    }

    public TranslatedSequence(Sequence source, GeneticCode geneticCode, int frame) {
        super(source);
        this.geneticCode = geneticCode;
        this.frame = frame;
    }

    @Override
    protected State[] filterSequence(Sequence source) {
        return Utils.translate(source.getStates(), this.geneticCode, this.frame);
    }

    @Override
    public SequenceType getSequenceType() {
        return SequenceType.AMINO_ACID;
    }
}

