/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.sequences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jebl.evolution.sequences.AminoAcidState;
import jebl.evolution.sequences.AminoAcids;
import jebl.evolution.sequences.BasicSequence;
import jebl.evolution.sequences.CodonState;
import jebl.evolution.sequences.GaplessSequence;
import jebl.evolution.sequences.GeneticCode;
import jebl.evolution.sequences.NucleotideState;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;

public class Utils {
    private Utils() {
    }

    public static Sequence translate(Sequence sequence, GeneticCode geneticCode) {
        return new BasicSequence(SequenceType.AMINO_ACID, sequence.getTaxon(), Utils.translate(sequence.getStates(), geneticCode));
    }

    public static Sequence translate(Sequence sequence, GeneticCode geneticCode, int readingFrame) {
        return new BasicSequence(SequenceType.AMINO_ACID, sequence.getTaxon(), Utils.translate(sequence.getStates(), geneticCode, readingFrame));
    }

    public static AminoAcidState[] translate(State[] states, GeneticCode geneticCode) {
        return Utils.translate(states, geneticCode, 1);
    }

    public static AminoAcidState[] translate(State[] states, GeneticCode geneticCode, int readingFrame) {
        if (states == null) {
            throw new NullPointerException("States array is null");
        }
        if (states.length == 0) {
            return new AminoAcidState[0];
        }
        if (readingFrame < 1 || readingFrame > 3) {
            throw new IllegalArgumentException("Reading frame should be between 1 and 3");
        }
        if (states[0] instanceof NucleotideState) {
            int offset = readingFrame - 1;
            int length = states.length - offset;
            if (length == 0) {
                return new AminoAcidState[0];
            }
            AminoAcidState[] translation = new AminoAcidState[length / 3];
            for (int i = 0; i < translation.length; ++i) {
                translation[i] = geneticCode.getTranslation((NucleotideState)states[i * 3 + offset], (NucleotideState)states[i * 3 + offset + 1], (NucleotideState)states[i * 3 + offset + 2]);
            }
            return translation;
        }
        if (states[0] instanceof CodonState) {
            if (readingFrame != 1) {
                throw new IllegalArgumentException("Can't translate codon sequences in anything other than reading frame 1");
            }
            AminoAcidState[] translation = new AminoAcidState[states.length];
            for (int i = 0; i < translation.length; ++i) {
                translation[i] = geneticCode.getTranslation((CodonState)states[i]);
            }
            return translation;
        }
        throw new IllegalArgumentException("Given states are not nucleotides or codons so cannot be translated");
    }

    public static boolean isPredominantlyRNA(CharSequence sequenceString, int maximumNonGapsToLookAt) {
        int length = sequenceString.length();
        int tCount = 0;
        int uCount = 0;
        if (maximumNonGapsToLookAt == -1) {
            maximumNonGapsToLookAt = Integer.MAX_VALUE;
        }
        for (int i = 0; i < length && maximumNonGapsToLookAt > 0; ++i) {
            char c = sequenceString.charAt(i);
            if (c != '-') {
                --maximumNonGapsToLookAt;
            }
            if (c == 'T' || c == 't') {
                ++tCount;
            }
            if (c != 'U' && c != 'u') continue;
            ++uCount;
        }
        return uCount > tCount;
    }

    private static String reverseComplement(String nucleotideSequence, boolean removeGaps) {
        boolean predominantlyRNA = Utils.isPredominantlyRNA(nucleotideSequence, -1);
        Sequence seq = new BasicSequence(SequenceType.NUCLEOTIDE, Taxon.getTaxon("x"), nucleotideSequence);
        if (removeGaps) {
            seq = new GaplessSequence(seq);
        }
        int length = seq.getLength();
        StringBuilder results = new StringBuilder();
        for (int i = length - 1; i >= 0; --i) {
            State state = seq.getState(i);
            NucleotideState complementaryState = Nucleotides.COMPLEMENTARY_STATES[state.getIndex()];
            if (predominantlyRNA && complementaryState.equals(Nucleotides.T_STATE)) {
                results.append('U');
                continue;
            }
            results.append(complementaryState.getCode());
        }
        return results.toString();
    }

    public static String reverseComplement(String nucleotideSequence) {
        return Utils.reverseComplement(nucleotideSequence, true);
    }

    public static String reverseComplementWithGaps(String nucleotideSequence) {
        return Utils.reverseComplement(nucleotideSequence, false);
    }

    public static String translateCharSequence(CharSequence nucleotideSequence, GeneticCode geneticCode) {
        Sequence seq = new BasicSequence(SequenceType.NUCLEOTIDE, Taxon.getTaxon("x"), nucleotideSequence);
        seq = new GaplessSequence(seq);
        State[] states = seq.getStates();
        states = Utils.translate(states, geneticCode);
        seq = new BasicSequence(SequenceType.AMINO_ACID, Taxon.getTaxon("x"), states);
        return seq.getString();
    }

    public static String translate(String nucleotideSequence, GeneticCode geneticCode) {
        return Utils.translateCharSequence(nucleotideSequence, geneticCode);
    }

    public static State[] stripGaps(State[] sequence) {
        if (sequence.length == 0) {
            return new State[0];
        }
        return Utils.stripStates(sequence, Collections.singletonList(sequence[0].getType().getGapState()));
    }

    public static State[] stripStates(State[] sequence, List<State> stripStates) {
        ArrayList<State> stripped = new ArrayList<State>();
        for (State state : sequence) {
            if (stripStates.contains(state)) continue;
            stripped.add(state);
        }
        return stripped.toArray(new State[0]);
    }

    public static State[] replaceStates(State[] sequence, List<State> searchStates, State replaceState) {
        ArrayList<State> stripped = new ArrayList<State>();
        for (State state : sequence) {
            if (searchStates.contains(state)) {
                stripped.add(replaceState);
                continue;
            }
            stripped.add(state);
        }
        return stripped.toArray(new State[0]);
    }

    public static State[] reverse(State[] sequence) {
        State[] reversed = new State[sequence.length];
        for (int i = 0; i < sequence.length; ++i) {
            reversed[i] = sequence[sequence.length - i - 1];
        }
        return reversed;
    }

    public static NucleotideState[] complement(NucleotideState[] sequence) {
        NucleotideState[] complemented = new NucleotideState[sequence.length];
        for (int i = 0; i < sequence.length; ++i) {
            complemented[i] = Nucleotides.COMPLEMENTARY_STATES[sequence[i].getIndex()];
        }
        return complemented;
    }

    public static NucleotideState[] reverseComplement(NucleotideState[] sequence) {
        NucleotideState[] reverseComplemented = new NucleotideState[sequence.length];
        for (int i = 0; i < sequence.length; ++i) {
            reverseComplemented[i] = Nucleotides.COMPLEMENTARY_STATES[sequence[sequence.length - i - 1].getIndex()];
        }
        return reverseComplemented;
    }

    public static byte[] getStateIndices(State[] sequence) {
        byte[] indices = new byte[sequence.length];
        int i = 0;
        for (State state : sequence) {
            indices[i] = (byte)state.getIndex();
            ++i;
        }
        return indices;
    }

    public static int getGaplessLocation(Sequence sequence, int gappedLocation) {
        int gapless = 0;
        int gapped = 0;
        for (State state : sequence.getStates()) {
            if (gapped == gappedLocation) {
                return gapless;
            }
            if (!state.isGap()) {
                ++gapless;
            }
            ++gapped;
        }
        return gapless;
    }

    public static int getGappedLocation(Sequence sequence, int gaplessLocation) {
        int gapless = 0;
        int gapped = 0;
        for (State state : sequence.getStates()) {
            if (gapless == gaplessLocation) {
                return gapped;
            }
            if (!state.isGap()) {
                ++gapless;
            }
            ++gapped;
        }
        return gapped;
    }

    public static SequenceType guessSequenceType(CharSequence seq) {
        SequenceType result;
        int sequenceLength;
        int canonicalNucStates = 0;
        int undeterminedStates = 0;
        int seqLen = sequenceLength = seq.length();
        int canonicalStateCount = Nucleotides.getCanonicalStateCount();
        boolean onlyValidNucleotides = true;
        boolean onlyValidAminoAcids = true;
        for (int k = 0; k < seqLen && (onlyValidNucleotides || onlyValidAminoAcids); ++k) {
            char c = seq.charAt(k);
            NucleotideState nucState = Nucleotides.getState(c);
            boolean isNucState = nucState != null;
            boolean isAminoState = AminoAcids.getState(c) != null;
            onlyValidAminoAcids &= isAminoState;
            if (!(onlyValidNucleotides &= isNucState)) continue;
            assert (isNucState);
            if (nucState.getIndex() < canonicalStateCount) {
                ++canonicalNucStates;
                continue;
            }
            if (nucState == Nucleotides.GAP_STATE) {
                --sequenceLength;
                continue;
            }
            if (nucState != Nucleotides.N_STATE) continue;
            ++undeterminedStates;
        }
        if (onlyValidNucleotides) {
            if (sequenceLength >= 100) {
                result = SequenceType.NUCLEOTIDE;
            } else {
                double threshold = 0.7;
                int nucStates = canonicalNucStates + undeterminedStates;
                result = (double)nucStates >= (double)sequenceLength * 0.7 ? SequenceType.NUCLEOTIDE : SequenceType.AMINO_ACID;
            }
        } else {
            result = onlyValidAminoAcids ? SequenceType.AMINO_ACID : null;
        }
        return result;
    }

    public static int getStopCodonCount(Sequence sequence) {
        if (sequence.getSequenceType() != SequenceType.AMINO_ACID) {
            throw new IllegalArgumentException("Sequence should be an amino acid sequence");
        }
        int count = 0;
        for (State state : sequence.getStates()) {
            if (!((AminoAcidState)state).isStop()) continue;
            ++count;
        }
        return count;
    }

    public static State[] cleanSequence(CharSequence seq, SequenceType type) {
        int count = 0;
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            if (type.getState(c) == null) continue;
            ++count;
        }
        State[] cleaned = new State[count];
        int index = 0;
        for (int i = 0; i < seq.length(); ++i) {
            char c = seq.charAt(i);
            State state = type.getState(c);
            if (state == null) continue;
            cleaned[index] = state;
            ++index;
        }
        return cleaned;
    }

    public static String toString(State[] states) {
        StringBuilder builder = new StringBuilder();
        for (State state : states) {
            builder.append(state.getCode());
        }
        return builder.toString();
    }
}

