/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.taxa;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jebl.evolution.taxa.TaxonomicLevel;
import jebl.util.Attributable;
import jebl.util.AttributableHelper;

public final class Taxon
implements Attributable,
Comparable {
    private AttributableHelper helper = null;
    private static AtomicInteger taxaCreatedSinceLastPurge = new AtomicInteger(0);
    private static AtomicLong lastPurgeTime = new AtomicLong(0L);
    private final String name;
    private static final Map<String, WeakReference<Taxon>> taxa = new HashMap<String, WeakReference<Taxon>>();
    private final TaxonomicLevel taxonomicLevel;

    private Taxon(String name) {
        this(name, null);
    }

    private Taxon(String name, TaxonomicLevel taxonomicLevel) {
        this.name = new String(name);
        this.taxonomicLevel = taxonomicLevel;
    }

    public String getName() {
        return this.name;
    }

    public TaxonomicLevel getTaxonomicLevel() {
        return this.taxonomicLevel;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void purgeGarbageCollectedTaxa() {
        Map<String, WeakReference<Taxon>> map = taxa;
        synchronized (map) {
            ArrayList<String> taxonNamesToPurge = new ArrayList<String>();
            for (Map.Entry<String, WeakReference<Taxon>> entry : taxa.entrySet()) {
                Taxon taxon = (Taxon)entry.getValue().get();
                if (taxon != null) continue;
                taxonNamesToPurge.add(entry.getKey());
            }
            for (String taxonName : taxonNamesToPurge) {
                taxa.remove(taxonName);
            }
            taxaCreatedSinceLastPurge.set(0);
            lastPurgeTime.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Taxon> getAllTaxa() {
        HashSet<Taxon> result = new HashSet<Taxon>();
        Map<String, WeakReference<Taxon>> map = taxa;
        synchronized (map) {
            Taxon.purgeGarbageCollectedTaxa();
            for (Map.Entry<String, WeakReference<Taxon>> entry : taxa.entrySet()) {
                Taxon taxon = (Taxon)entry.getValue().get();
                if (taxon == null) continue;
                result.add(taxon);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Taxon getTaxon(String name) {
        Taxon taxon;
        if (name == null) {
            throw new IllegalArgumentException("Illegal null string for taxon name");
        }
        if (name.length() == 0) assert (false) : "Illegal empty string for taxon name";
        Map<String, WeakReference<Taxon>> map = taxa;
        synchronized (map) {
            WeakReference<Taxon> taxonReference;
            if (taxaCreatedSinceLastPurge.get() > 10000 || lastPurgeTime.get() + 10000L < System.currentTimeMillis()) {
                Taxon.purgeGarbageCollectedTaxa();
            }
            Taxon taxon2 = taxon = (taxonReference = taxa.get(name)) == null ? null : (Taxon)taxonReference.get();
            if (taxon == null) {
                taxaCreatedSinceLastPurge.incrementAndGet();
                taxon = new Taxon(name);
                taxa.put(taxon.getName(), new WeakReference<Taxon>(taxon));
            }
        }
        return taxon;
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((Taxon)o).getName());
    }

    public boolean equals(Taxon t) {
        return this.name.equals(t.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

