/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;

public abstract class AbstractRootedTree
implements RootedTree {
    @Override
    public int getExternalNodeCount(Node node) {
        if (this.isExternal(node)) {
            return 1;
        }
        int externalNodeCount = 0;
        for (Node child : this.getChildren(node)) {
            externalNodeCount += this.getExternalNodeCount(child);
        }
        return externalNodeCount;
    }

    @Override
    public List<Node> getExternalNodes(Node node) {
        if (this.isExternal(node)) {
            return Collections.singletonList(node);
        }
        ArrayList<Node> tips = new ArrayList<Node>();
        for (Node child : this.getChildren(node)) {
            tips.addAll(this.getExternalNodes(child));
        }
        return tips;
    }
}

