/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.TreeBuilder;
import jebl.evolution.trees.Utils;
import jebl.util.ProgressListener;

public abstract class ConsensusTreeBuilder<T extends Tree>
implements TreeBuilder<T> {
    public static final String DEFAULT_SUPPORT_ATTRIBUTE_NAME = "Consensus support(%)";
    private String supportAttributeName;
    private boolean supportAsPercent;
    protected final int nExternalNodes;
    protected final List<Taxon> taxons;
    private final List<ProgressListener> listeners = new ArrayList<ProgressListener>();

    ConsensusTreeBuilder(Tree[] trees) {
        this(trees, DEFAULT_SUPPORT_ATTRIBUTE_NAME, true);
    }

    ConsensusTreeBuilder(Tree[] trees, String supportAttributeName, boolean supportInPercent) throws IllegalArgumentException {
        if (trees.length == 0) {
            throw new IllegalArgumentException("Expected at least one tree, but got none");
        }
        this.supportAttributeName = supportAttributeName;
        this.supportAsPercent = supportInPercent;
        this.nExternalNodes = trees[0].getExternalNodes().size();
        this.taxons = Collections.unmodifiableList(new ArrayList<Taxon>(trees[0].getTaxa()));
        Utils.assertAllTreesHaveTheSameTaxa(Arrays.asList(trees));
    }

    public abstract String getMethodDescription();

    protected String getSupportDescription(double supportThreshold) {
        Object supporDescription = supportThreshold == 1.0 ? "Strict" : (supportThreshold == 0.5 ? "Majority" : "Above " + 100.0 * supportThreshold + "% support");
        return supporDescription;
    }

    public String getSupportAttributeName() {
        return this.supportAttributeName;
    }

    public boolean isSupportAsPercent() {
        return this.supportAsPercent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProgressListener(ProgressListener listener) {
        List<ProgressListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireSetProgress(double fractionCompleted) {
        ArrayList<ProgressListener> listenersCopy;
        boolean canceled = false;
        List<ProgressListener> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<ProgressListener>(this.listeners);
        }
        for (ProgressListener listener : listenersCopy) {
            if (!listener.setProgress(fractionCompleted)) continue;
            canceled = true;
        }
        return canceled;
    }

    public static enum Method {
        GREEDY("Greedy"),
        MRCAC("MRCA Clustering");

        private final String name;

        private Method(String name) {
            this.name = name;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.name;
        }
    }
}

