/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.MutableRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;
import jebl.util.FixedBitSet;

class MRCACConsensusTreeBuilder
extends ConsensusTreeBuilder<RootedTree> {
    RootedTree[] trees;
    private double supportThreshold;
    private List<FixedBitSet> tipsInCluster;
    private TreeInfo[] info;
    private boolean debug = false;
    double[][] height;

    public MRCACConsensusTreeBuilder(Tree[] trees, double supportThreshold) {
        this(trees, supportThreshold, "Consensus support(%)", true);
    }

    public MRCACConsensusTreeBuilder(Tree[] trees, double supportThreshold, String supportAttributeName, boolean asPercent) {
        super(trees, supportAttributeName, asPercent);
        this.trees = new RootedTree[trees.length];
        for (int i = 0; i < trees.length; ++i) {
            this.trees[i] = (RootedTree)trees[i];
        }
        this.supportThreshold = supportThreshold;
        this.info = new TreeInfo[trees.length];
        for (int iTree = 0; iTree < trees.length; ++iTree) {
            this.info[iTree] = new TreeInfo(this.trees[iTree]);
        }
    }

    @Override
    public RootedTree build() {
        return this.earliestCommonAncestorClustering(this.supportThreshold);
    }

    @Override
    public String getMethodDescription() {
        return this.getSupportDescription(this.supportThreshold) + " MRCACC";
    }

    void setupPairs() {
        this.height = new double[this.nExternalNodes][this.nExternalNodes];
        if (this.debug) {
            for (int k = 0; k < this.taxons.size(); ++k) {
                System.out.print(((Taxon)this.taxons.get(k)).getName() + ":" + k + ", ");
            }
            System.out.println();
        }
        for (int iTree = 0; iTree < this.trees.length; ++iTree) {
            if (this.debug) {
                System.out.println("tree " + Utils.toNewick(this.trees[iTree]));
            }
            TreeInfo info = this.info[iTree];
            for (int nodeIndex : info.postorder) {
                int leftChildIndex = info.nodeChildren[nodeIndex][0];
                int rightChildIndex = info.nodeChildren[nodeIndex][1];
                FixedBitSet left = info.nodesTipSet[leftChildIndex];
                FixedBitSet right = info.nodesTipSet[rightChildIndex];
                int lTip = left.nextOnBit(0);
                while (lTip >= 0) {
                    int rTip = right.nextOnBit(0);
                    while (rTip >= 0) {
                        double h = this.trees[iTree].getHeight(info.allNodes[nodeIndex]);
                        double[] dArray = this.height[Math.min(lTip, rTip)];
                        int n = Math.max(lTip, rTip);
                        dArray[n] = dArray[n] + h;
                        rTip = right.nextOnBit(rTip + 1);
                    }
                    lTip = left.nextOnBit(lTip + 1);
                }
            }
        }
        for (int d = 0; d < this.nExternalNodes; ++d) {
            int d1 = d + 1;
            while (d1 < this.nExternalNodes) {
                double[] dArray = this.height[d];
                int n = d1++;
                dArray[n] = dArray[n] / (double)this.trees.length;
            }
        }
    }

    private double[] updateHeights(int i, int j) {
        int nClusters = this.tipsInCluster.size();
        double[] distances = new double[nClusters + 1];
        FixedBitSet joined = new FixedBitSet(this.tipsInCluster.get(i));
        joined.union(this.tipsInCluster.get(j));
        int numberOfTreesSupportClade = 0;
        if (nClusters == 2) {
            for (RootedTree tree : this.trees) {
                distances[1] = distances[1] + tree.getHeight(tree.getRootNode());
            }
            distances[2] = 1.0;
        } else {
            for (int l = 0; l < nClusters; ++l) {
                if (l == i || l == j) continue;
                FixedBitSet joinedWithL = new FixedBitSet(joined);
                joinedWithL.union(this.tipsInCluster.get(l));
                block2: for (int iTree = 0; iTree < this.trees.length; ++iTree) {
                    RootedTree tree;
                    tree = this.trees[iTree];
                    TreeInfo info = this.info[iTree];
                    boolean commonAnncestorFound = false;
                    for (int nodeIndex : info.postorder) {
                        FixedBitSet nodeBS = info.nodesTipSet[nodeIndex];
                        if (!commonAnncestorFound && joined.setInclusion(nodeBS)) {
                            int tipsInClusters;
                            int tipsInSubtree = nodeBS.cardinality();
                            numberOfTreesSupportClade += tipsInSubtree == (tipsInClusters = joined.cardinality()) ? 1 : 0;
                            commonAnncestorFound = true;
                        }
                        if (!joinedWithL.setInclusion(nodeBS)) continue;
                        int n = l;
                        distances[n] = distances[n] + tree.getHeight(info.allNodes[nodeIndex]);
                        continue block2;
                    }
                }
            }
        }
        int l = 0;
        while (l < nClusters) {
            int n = l++;
            distances[n] = distances[n] / (double)this.trees.length;
        }
        distances[nClusters] = (double)numberOfTreesSupportClade / (double)this.trees.length;
        return distances;
    }

    private RootedTree earliestCommonAncestorClustering(double supportThreshold) {
        MutableRootedTree consensus = new MutableRootedTree();
        ArrayList<Node> subTrees = new ArrayList<Node>(this.nExternalNodes);
        double[] tipHeights = new double[this.taxons.size()];
        for (RootedTree tree : this.trees) {
            for (Node e : tree.getExternalNodes()) {
                int i;
                int n = i = this.taxons.indexOf(tree.getTaxon(e));
                tipHeights[n] = tipHeights[n] + tree.getHeight(e);
            }
        }
        this.tipsInCluster = new ArrayList<FixedBitSet>(this.nExternalNodes);
        for (int k = 0; k < this.nExternalNodes; ++k) {
            FixedBitSet b = new FixedBitSet(this.nExternalNodes);
            b.set(k);
            this.tipsInCluster.add(b);
            Node externalNode = consensus.createExternalNode((Taxon)this.taxons.get(k));
            consensus.setHeight(externalNode, tipHeights[k] / (double)this.trees.length);
            subTrees.add(externalNode);
        }
        this.setupPairs();
        for (int nClusters = this.nExternalNodes; nClusters > 1; --nClusters) {
            int i;
            double mostRecentAnncestorHeight = Double.MAX_VALUE;
            int besti = 0;
            int bestj = 0;
            for (int d = 0; d < nClusters; ++d) {
                for (int d1 = d + 1; d1 < nClusters; ++d1) {
                    if (!(this.height[d][d1] < mostRecentAnncestorHeight)) continue;
                    mostRecentAnncestorHeight = this.height[d][d1];
                    besti = d;
                    bestj = d1;
                }
            }
            double[] newHeights = this.updateHeights(besti, bestj);
            double supportForClade = newHeights[newHeights.length - 1];
            Node[] children = new Node[]{(Node)subTrees.get(besti), (Node)subTrees.get(bestj)};
            double maxChild = Math.max(consensus.getHeight(children[0]), consensus.getHeight(children[1]));
            mostRecentAnncestorHeight = Math.max(mostRecentAnncestorHeight, maxChild);
            MutableRootedTree.MutableRootedNode sub = consensus.createInternalNode(Arrays.asList(children));
            consensus.setHeight(sub, mostRecentAnncestorHeight);
            if (nClusters > 2) {
                sub.setAttribute(this.getSupportAttributeName(), this.isSupportAsPercent() ? 100.0 * supportForClade : supportForClade);
            }
            subTrees.set(besti, sub);
            this.tipsInCluster.get(besti).union(this.tipsInCluster.get(bestj));
            this.tipsInCluster.remove(bestj);
            subTrees.remove(bestj);
            for (i = 0; i < nClusters; ++i) {
                if (besti < i) {
                    this.height[besti][i] = newHeights[i];
                    continue;
                }
                this.height[i][besti] = newHeights[i];
            }
            for (i = 0; i < nClusters - 1; ++i) {
                for (int j = bestj; j < nClusters - 1; ++j) {
                    this.height[i][j] = this.height[i + (i >= bestj ? 1 : 0)][j + 1];
                }
            }
        }
        if (this.isSupportAsPercent()) {
            supportThreshold *= 100.0;
        }
        for (Node node : consensus.getInternalNodes()) {
            Object sup = node.getAttribute(this.getSupportAttributeName());
            if (sup == null || !((Double)sup < supportThreshold)) continue;
            consensus.removeInternalNode(node);
        }
        return consensus;
    }

    class TreeInfo {
        FixedBitSet[] nodesTipSet;
        int[] postorder;
        int[][] nodeChildren;
        private Node[] allNodes;

        TreeInfo(RootedTree tree) {
            this.allNodes = new Node[tree.getNodes().size()];
            for (Node node : tree.getExternalNodes()) {
                int i = MRCACConsensusTreeBuilder.this.taxons.indexOf(tree.getTaxon(node));
                this.allNodes[i] = node;
            }
            int k = MRCACConsensusTreeBuilder.this.nExternalNodes;
            Iterator<Node> iterator = tree.getInternalNodes().iterator();
            while (iterator.hasNext()) {
                Node node;
                this.allNodes[k] = node = iterator.next();
                ++k;
            }
            this.postorder = new int[this.allNodes.length - MRCACConsensusTreeBuilder.this.nExternalNodes];
            this.nodesTipSet = new FixedBitSet[this.allNodes.length];
            this.nodeChildren = new int[this.allNodes.length][];
            this.inPostorder(tree, tree.getRootNode(), 0);
        }

        private int inPostorder(RootedTree tree, Node node, int nPost) {
            List<Node> all = Arrays.asList(this.allNodes);
            FixedBitSet b = new FixedBitSet(this.allNodes.length);
            int c = all.indexOf(node);
            if (tree.isExternal(node)) {
                b.set(c);
            } else {
                List<Node> children = tree.getChildren(node);
                this.nodeChildren[c] = new int[children.size()];
                int nc = 0;
                for (Node child : children) {
                    int c1;
                    nPost = this.inPostorder(tree, child, nPost);
                    this.nodeChildren[c][nc] = c1 = all.indexOf(child);
                    ++nc;
                    b.union(this.nodesTipSet[c1]);
                }
                this.postorder[nPost] = c;
                ++nPost;
            }
            this.nodesTipSet[c] = b;
            return nPost;
        }
    }
}

