/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedFromUnrooted;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.SimpleTree;
import jebl.evolution.trees.Tree;
import jebl.util.FixedBitSet;

public class MostProbableTopology {
    final List<Tree> trees;
    final boolean rootedSet;
    private final List<Taxon> taxa;
    final String consAttributeName = "Consensus support(%)";

    public MostProbableTopology(Collection<? extends Tree> trees) {
        this.trees = new ArrayList<Tree>(trees);
        Tree tree0 = this.trees.get(0);
        this.rootedSet = tree0 instanceof RootedTree && !((RootedTree)tree0).conceptuallyUnrooted();
        this.taxa = new ArrayList<Taxon>(trees.iterator().next().getTaxa());
    }

    public List<Tree> get(int max, double threshold) {
        int nTrees = this.trees.size();
        LinkedHashMap<Object, TopologyEntry> m = new LinkedHashMap<Object, TopologyEntry>(nTrees);
        for (int nTree = 0; nTree < nTrees; ++nTree) {
            Tree t = this.trees.get(nTree);
            String rep = this.standardTopologyRepresentation(t);
            TopologyEntry topologyEntry = (TopologyEntry)m.get(rep);
            if (topologyEntry == null) {
                m.put(rep, new TopologyEntry(nTree));
                continue;
            }
            ++topologyEntry.count;
        }
        Comparator<Map.Entry<String, TopologyEntry>> comparator = new Comparator<Map.Entry<String, TopologyEntry>>(){

            @Override
            public int compare(Map.Entry<String, TopologyEntry> o1, Map.Entry<String, TopologyEntry> o2) {
                return o2.getValue().count - o1.getValue().count;
            }
        };
        PriorityQueue<Map.Entry<String, TopologyEntry>> queue = new PriorityQueue<Map.Entry<String, TopologyEntry>>(m.size(), comparator);
        for (Map.Entry entry : m.entrySet()) {
            queue.add(entry);
        }
        final ArrayList<Info> candidates = new ArrayList<Info>();
        int n = (int)(threshold * (double)nTrees);
        while (queue.peek() != null && candidates.size() <= n && (max <= 0 || candidates.size() < max)) {
            Info candidate;
            Map.Entry<String, TopologyEntry> e = queue.poll();
            TopologyEntry info = e.getValue();
            Tree tree = this.trees.get(info.representativeIndex);
            if (this.rootedSet) {
                SimpleRootedTree r = new SimpleRootedTree((RootedTree)tree);
                candidate = new TreeInfo(r);
            } else {
                SimpleTree t = new SimpleTree(tree);
                candidate = new UnrootedTreeInfo(t);
            }
            candidates.add(candidate);
            Tree tree1 = candidate.getTree();
            tree1.setAttribute("Frequency", 100.0 * (double)info.count / (double)nTrees);
            tree1.setAttribute("name", "topology_" + candidates.size());
        }
        for (int nTree = 0; nTree < nTrees; ++nTree) {
            Tree t;
            if (this.rootedSet) {
                t = (RootedTree)this.trees.get(nTree);
                new TraversableRootedTree((RootedTree)t).traverse(new NodeCallback(){
                    final /* synthetic */ RootedTree val$t;
                    final /* synthetic */ List val$candidates;
                    {
                        this.val$t = rootedTree;
                        this.val$candidates = list;
                    }

                    @Override
                    public void visit(Node n, FixedBitSet tipSet) {
                        double height = this.val$t.getHeight(n);
                        for (Info ti : this.val$candidates) {
                            TreeInfo.NodeInfo ni = ((TreeInfo)ti).m.get(tipSet);
                            if (ni == null) continue;
                            ni.add(height);
                        }
                    }
                });
                continue;
            }
            t = this.trees.get(nTree);
            new TraversableTree(t).traverse(new EdgeCallback(){

                @Override
                public void visit(Edge e, FixedBitSet tipSet) {
                    double length = e.getLength();
                    for (Info ti : candidates) {
                        UnrootedTreeInfo.EdgeInfo ei = ((UnrootedTreeInfo)ti).m.get(tipSet);
                        if (ei == null) continue;
                        ei.add(length);
                    }
                }
            });
        }
        ArrayList<Tree> results = new ArrayList<Tree>();
        for (Info info : candidates) {
            info.setBranches();
            results.add(info.getTree());
        }
        return results;
    }

    private String standardTopologyRepresentation(Tree t) {
        if (t instanceof RootedTree) {
            RootedTree r = (RootedTree)t;
            return this.standardTop(r, r.getRootNode());
        }
        List<Node> adj = t.getAdjacencies(t.getNode(this.taxa.get(0)));
        assert (adj.size() == 1);
        RootedFromUnrooted r = new RootedFromUnrooted(t, adj.get(0), true);
        return this.standardTop(r, r.getRootNode());
    }

    private String standardTop(RootedTree t, Node n) {
        if (t.isExternal(n)) {
            return Integer.toString(this.taxa.indexOf(t.getTaxon(n)));
        }
        List<Node> dec = t.getChildren(n);
        String[] strings = new String[dec.size()];
        for (int k = 0; k < dec.size(); ++k) {
            strings[k] = this.standardTop(t, dec.get(k));
        }
        List<String> list = Arrays.asList(strings);
        Collections.sort(list);
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(sb.length() == 0 ? Character.valueOf('(') : ",");
            sb.append(s);
        }
        sb.append(')');
        return sb.toString();
    }

    private class TopologyEntry {
        int count;
        int representativeIndex;

        public TopologyEntry(int nTree) {
            this.representativeIndex = nTree;
            this.count = 1;
        }
    }

    private class TreeInfo
    extends TraversableRootedTree
    implements Info {
        public final Map<FixedBitSet, NodeInfo> m;

        TreeInfo(SimpleRootedTree t) {
            super(t);
            this.m = new LinkedHashMap<FixedBitSet, NodeInfo>();
            this.traverse(new NodeCallback(){

                @Override
                public void visit(Node n, FixedBitSet tipSet) {
                    TreeInfo.this.m.put(tipSet, new NodeInfo(n));
                }
            });
        }

        @Override
        public Tree getTree() {
            return this.t;
        }

        @Override
        public void setBranches() {
            this.traverse(new NodeCallback(){

                @Override
                public void visit(Node n, FixedBitSet tipSet) {
                    NodeInfo info = TreeInfo.this.m.get(tipSet);
                    assert (info != null);
                    double h = info.length();
                    for (Node c : TreeInfo.this.t.getChildren(info.n)) {
                        double ch = TreeInfo.this.t.getHeight(c);
                        if (!(ch > h)) continue;
                        h = ch;
                    }
                    ((SimpleRootedTree)TreeInfo.this.t).setHeight(info.n, h);
                    info.n.setAttribute("Consensus support(%)", 100.0 * (double)info.count / (double)MostProbableTopology.this.trees.size());
                }
            });
        }

        class NodeInfo
        extends ConditionalData {
            Node n;

            public NodeInfo(Node n) {
                this.n = n;
            }
        }
    }

    private class UnrootedTreeInfo
    extends TraversableTree
    implements Info {
        public final Map<FixedBitSet, EdgeInfo> m;

        @Override
        public Tree getTree() {
            return this.t;
        }

        public UnrootedTreeInfo(SimpleTree t) {
            super(t);
            this.m = new LinkedHashMap<FixedBitSet, EdgeInfo>();
            this.traverse(new EdgeCallback(){

                @Override
                public void visit(Edge e, FixedBitSet tipSet) {
                    UnrootedTreeInfo.this.m.put(tipSet, new EdgeInfo(e));
                }
            });
        }

        @Override
        public void setBranches() {
            this.traverse(new EdgeCallback(){

                @Override
                public void visit(Edge e, FixedBitSet tipSet) {
                    EdgeInfo info = UnrootedTreeInfo.this.m.get(tipSet);
                    assert (info != null);
                    double h = info.length();
                    ((SimpleTree)UnrootedTreeInfo.this.t).setEdgeLength(info.e, h);
                    double support = 100.0 * (double)info.count / (double)MostProbableTopology.this.trees.size();
                    info.e.setAttribute("Consensus support(%)", support);
                }
            });
        }

        class EdgeInfo
        extends ConditionalData {
            Edge e;

            public EdgeInfo(Edge e) {
                this.e = e;
            }
        }
    }

    private static interface Info {
        public Tree getTree();

        public void setBranches();
    }

    class TraversableRootedTree {
        public final RootedTree t;

        TraversableRootedTree(RootedTree t) {
            this.t = t;
        }

        void traverse(NodeCallback call) {
            this.traverse(call, this.t.getRootNode());
        }

        private FixedBitSet traverse(NodeCallback call, Node n) {
            FixedBitSet tipSet = new FixedBitSet(MostProbableTopology.this.taxa.size());
            if (this.t.isExternal(n)) {
                tipSet.set(MostProbableTopology.this.taxa.indexOf(this.t.getTaxon(n)));
            } else {
                for (Node c : this.t.getChildren(n)) {
                    FixedBitSet cTips = this.traverse(call, c);
                    tipSet.union(cTips);
                }
            }
            call.visit(n, tipSet);
            return tipSet;
        }
    }

    private static interface NodeCallback {
        public void visit(Node var1, FixedBitSet var2);
    }

    private class TraversableTree {
        final Tree t;

        TraversableTree(Tree t) {
            this.t = t;
        }

        void traverse(EdgeCallback call) {
            Node tip = this.t.getExternalNodes().iterator().next();
            this.traverse(call, this.t.getAdjacencies(tip).get(0), tip);
        }

        private FixedBitSet traverse(EdgeCallback call, Node n, Node root) {
            boolean needComplement;
            FixedBitSet tipSet;
            block7: {
                tipSet = new FixedBitSet(MostProbableTopology.this.taxa.size());
                if (this.t.isExternal(n)) {
                    tipSet.set(MostProbableTopology.this.taxa.indexOf(this.t.getTaxon(n)));
                } else {
                    for (Node c : this.t.getAdjacencies(n)) {
                        if (c == root) continue;
                        FixedBitSet cTips = this.traverse(call, c, n);
                        tipSet.union(cTips);
                    }
                }
                boolean bl = needComplement = !tipSet.contains(0);
                if (needComplement) {
                    tipSet.complement();
                }
                try {
                    call.visit(this.t.getEdge(n, root), tipSet);
                }
                catch (Graph.NoEdgeException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
            if (needComplement) {
                FixedBitSet b = new FixedBitSet(tipSet);
                b.complement();
                return b;
            }
            return tipSet;
        }
    }

    private static interface EdgeCallback {
        public void visit(Edge var1, FixedBitSet var2);
    }

    private class ConditionalData {
        double hSum = 0.0;
        int count = 0;

        public void add(double v) {
            this.hSum += v;
            ++this.count;
        }

        public double length() {
            assert (this.count > 0);
            return this.hSum / (double)this.count;
        }
    }
}

