/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.Arrays;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ClusteringTreeBuilder;
import jebl.evolution.trees.SimpleTree;
import jebl.evolution.trees.Tree;

public class NeighborJoiningTreeBuilder
extends ClusteringTreeBuilder<Tree> {
    private final SimpleTree tree = new SimpleTree();
    private double[] r;

    public NeighborJoiningTreeBuilder(DistanceMatrix distanceMatrix) {
        super(distanceMatrix, 3);
        this.r = new double[distanceMatrix.getSize()];
    }

    @Override
    protected void findNextPair() {
        int i = 0;
        while (i < this.numClusters) {
            this.r[i] = 0.0;
            for (int j = 0; j < this.numClusters; ++j) {
                double dist = this.getDist(i, j);
                int n = i;
                this.r[n] = this.r[n] + dist;
            }
            int n = i++;
            this.r[n] = this.r[n] / ((double)this.numClusters - 2.0);
        }
        this.besti = 0;
        this.bestj = 1;
        double smin = Double.MAX_VALUE;
        for (int i2 = 0; i2 < this.numClusters - 1; ++i2) {
            for (int j = i2 + 1; j < this.numClusters; ++j) {
                double sij = this.getDist(i2, j) - (this.r[i2] + this.r[j]);
                if (!(sij < smin)) continue;
                smin = sij;
                this.besti = i2;
                this.bestj = j;
            }
        }
    }

    @Override
    protected Tree getTree() {
        return this.tree;
    }

    @Override
    protected Node createExternalNode(Taxon taxon) {
        return this.tree.createExternalNode(taxon);
    }

    @Override
    protected Node createInternalNode(Node[] nodes, double[] distances) {
        assert (nodes.length == distances.length);
        Node node = this.tree.createInternalNode(Arrays.asList(nodes));
        for (int k = 0; k < nodes.length; ++k) {
            this.tree.setEdgeLength(node, nodes[k], distances[k]);
        }
        return node;
    }

    @Override
    protected void finish() {
        int abi = this.alias[0];
        int abj = this.alias[1];
        double dij = this.getDist(0, 1);
        this.tree.addEdge(this.clusters[abi], this.clusters[abj], dij);
        super.finish();
    }

    @Override
    protected double[] joinClusters() {
        double dij = this.getDist(this.besti, this.bestj);
        double li = (dij + (this.r[this.besti] - this.r[this.bestj])) * 0.5;
        double lj = dij - li;
        if (li < 0.0) {
            li = 0.0;
        }
        if (lj < 0.0) {
            lj = 0.0;
        }
        return new double[]{li, lj};
    }

    @Override
    protected double updatedDistance(int k) {
        int i = this.besti;
        int j = this.bestj;
        double d = (this.getDist(k, i) + this.getDist(k, j) - this.getDist(i, j)) * 0.5;
        return Math.max(d, 0.0);
    }
}

