/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.AbstractRootedTree;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.AttributableHelper;
import jebl.util.HashPair;

public final class ReRootedTree
extends AbstractRootedTree {
    private RootedTree source = null;
    private ReRootedNode rootNode = null;
    private final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Map<Taxon, Node> externalNodes = new LinkedHashMap<Taxon, Node>();
    private boolean heightsKnown = false;
    private boolean lengthsKnown = false;
    private boolean hasHeights = false;
    private boolean hasLengths = false;

    public ReRootedTree(RootedTree source, Node ingroupNode, Node outgroupNode, double ingroupBranchLength) throws Graph.NoEdgeException {
        this.source = source;
        ArrayList<Node> children = new ArrayList<Node>();
        Node node1 = this.createNodes(source, outgroupNode, ingroupNode);
        this.setLength(node1, ingroupBranchLength);
        children.add(node1);
        Node node2 = this.createNodes(source, ingroupNode, outgroupNode);
        double l = source.getEdgeLength(ingroupNode, outgroupNode);
        if (outgroupNode == source.getRootNode()) {
            for (Node adj : source.getAdjacencies(outgroupNode)) {
                if (adj == ingroupNode) continue;
                l += source.getEdgeLength(outgroupNode, adj);
            }
        }
        this.setLength(node2, Math.max(l - ingroupBranchLength, 0.0));
        children.add(node2);
        this.createInternalNode(null, children);
    }

    public Node createNodes(RootedTree tree, Node parent, Node child) throws Graph.NoEdgeException {
        double length;
        Node newNode = null;
        if (tree.isExternal(child)) {
            newNode = this.createExternalNode(child, tree.getTaxon(child));
            length = tree.getEdgeLength(parent, child);
        } else {
            List<Node> adjacencies = tree.getAdjacencies(child);
            if (adjacencies.size() == 2) {
                newNode = adjacencies.get(0) == parent ? this.createNodes(tree, child, adjacencies.get(1)) : this.createNodes(tree, child, adjacencies.get(0));
                length = tree.getEdgeLength(adjacencies.get(0), child) + tree.getEdgeLength(adjacencies.get(1), child);
            } else {
                ArrayList<Node> children = new ArrayList<Node>();
                for (Node child2 : adjacencies) {
                    if (child2 == parent) continue;
                    children.add(this.createNodes(tree, child, child2));
                }
                newNode = tree.getParent(parent) == child ? this.createInternalNode(parent, children) : this.createInternalNode(child, children);
                length = tree.getEdgeLength(parent, child);
            }
        }
        this.setLength(newNode, length);
        return newNode;
    }

    private Node createExternalNode(Node source, Taxon taxon) {
        ReRootedNode node = new ReRootedNode(source, taxon);
        this.externalNodes.put(taxon, node);
        return node;
    }

    private ReRootedNode createInternalNode(Node source, List<? extends Node> children) {
        ReRootedNode node = new ReRootedNode(source, children);
        for (Node node2 : children) {
            ((ReRootedNode)node2).setParent(node);
        }
        this.internalNodes.add(node);
        this.rootNode = node;
        return node;
    }

    public Node getSourceNode(Node node) {
        return ((ReRootedNode)node).source;
    }

    public void setHeight(Node node, double height) {
        this.lengthsKnown = false;
        this.heightsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((ReRootedNode)node).setHeight(height);
    }

    public void setLength(Node node, double length) {
        this.heightsKnown = false;
        this.lengthsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((ReRootedNode)node).setLength(length);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return new ArrayList<Node>(((ReRootedNode)node).getChildren());
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public boolean isHeightsKnown() {
        return this.heightsKnown;
    }

    @Override
    public double getHeight(Node node) {
        if (!this.hasHeights) {
            throw new IllegalArgumentException("This tree has no node heights");
        }
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((ReRootedNode)node).getHeight();
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public boolean isLengthsKnown() {
        return this.lengthsKnown;
    }

    @Override
    public double getLength(Node node) {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("This tree has no branch lengths");
        }
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((ReRootedNode)node).getLength();
    }

    @Override
    public Node getParent(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((ReRootedNode)node).getParent();
    }

    public Edge getParentEdge(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode");
        }
        return ((ReRootedNode)node).getEdge();
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return new LinkedHashSet<Node>(this.externalNodes.values());
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(this.externalNodes.keySet());
    }

    @Override
    public Taxon getTaxon(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((ReRootedNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        if (!(node instanceof ReRootedNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of SimpleRootedNode.  It is an instance of " + node.getClass().getName());
        }
        return ((ReRootedNode)node).getChildren().size() == 0;
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.externalNodes.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        ReRootedNode node = (ReRootedNode)this.externalNodes.get(from);
        if (node == null) {
            throw new IllegalArgumentException("Unknown taxon " + from + "; can't rename to " + to);
        }
        node.setTaxon(to);
        this.externalNodes.remove(from);
        this.externalNodes.put(to, node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node adjNode : this.getAdjacencies(node)) {
            edges.add(((ReRootedNode)adjNode).getEdge());
        }
        return edges;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((ReRootedNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((ReRootedNode)node1).getParent() == node2) {
            return ((ReRootedNode)node1).getEdge();
        }
        if (((ReRootedNode)node2).getParent() == node1) {
            return ((ReRootedNode)node2).getEdge();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((ReRootedNode)node1).getParent() == node2) {
            if (this.heightsKnown) {
                return ((ReRootedNode)node2).getHeight() - ((ReRootedNode)node1).getHeight();
            }
            return ((ReRootedNode)node1).getLength();
        }
        if (((ReRootedNode)node2).getParent() == node1) {
            if (this.heightsKnown) {
                return ((ReRootedNode)node1).getHeight() - ((ReRootedNode)node2).getHeight();
            }
            return ((ReRootedNode)node2).getLength();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public Node[] getNodes(Edge edge) {
        for (Node node : this.getNodes()) {
            if (((ReRootedNode)node).getEdge() != edge) continue;
            return new Node[]{node, ((ReRootedNode)node).getParent()};
        }
        return null;
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.internalNodes);
        nodes.addAll(this.externalNodes.values());
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((ReRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            edges.add(((ReRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((ReRootedNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            int deg = node.getDegree();
            if (deg != degree) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void calculateNodeHeights() {
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Can't calculate node heights because branch lengths not known");
        }
        this.nodeLengthsToHeights(this.rootNode, 0.0);
        double maxHeight = 0.0;
        for (Node externalNode : this.getExternalNodes()) {
            if (!(((ReRootedNode)externalNode).getHeight() > maxHeight)) continue;
            maxHeight = ((ReRootedNode)externalNode).getHeight();
        }
        for (Node node : this.getNodes()) {
            ((ReRootedNode)node).setHeight(maxHeight - ((ReRootedNode)node).getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(ReRootedNode node, double height) {
        double newHeight = height;
        if (node.getLength() > 0.0) {
            newHeight += node.getLength();
        }
        node.setHeight(newHeight);
        for (Node child : node.getChildren()) {
            this.nodeLengthsToHeights((ReRootedNode)child, newHeight);
        }
    }

    protected void calculateBranchLengths() {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("Can't calculate branch lengths because node heights not known");
        }
        this.nodeHeightsToLengths(this.rootNode, this.getHeight(this.rootNode));
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(ReRootedNode node, double height) {
        double h = node.getHeight();
        node.setLength(h >= 0.0 ? height - h : 1.0);
        for (Node child : node.getChildren()) {
            this.nodeHeightsToLengths((ReRootedNode)child, node.getHeight());
        }
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return false;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.rootNode;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.source.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        return this.source.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        this.source.removeAttribute(name);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.source.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        return this.source.getAttributeMap();
    }

    public static RootedTree rootTreeAtCenter(RootedTree tree) {
        LinkedHashMap<HashPair<Node>, Double> dists = new LinkedHashMap<HashPair<Node>, Double>();
        try {
            double maxDistance = -1.7976931348623157E308;
            Node current = null;
            Node direction = null;
            for (Node e : tree.getExternalNodes()) {
                for (Node n : tree.getAdjacencies(e)) {
                    double d = ReRootedTree.dist(tree, e, n, dists);
                    if (!(d > maxDistance)) continue;
                    maxDistance = d;
                    current = e;
                    direction = n;
                }
            }
            double distanceLeft = maxDistance / 2.0;
            while (true) {
                double len;
                if (distanceLeft <= (len = tree.getEdgeLength(current, direction))) {
                    return new ReRootedTree(tree, current, direction, distanceLeft);
                }
                distanceLeft -= len;
                maxDistance = -1.7976931348623157E308;
                Node next = null;
                for (Node n : tree.getAdjacencies(direction)) {
                    double d;
                    if (n == current || !((d = ReRootedTree.dist(tree, direction, n, dists)) > maxDistance)) continue;
                    maxDistance = d;
                    next = n;
                }
                current = direction;
                direction = next;
            }
        }
        catch (Graph.NoEdgeException e1) {
            return null;
        }
    }

    private static double dist(Tree tree, Node root, Node node, Map<HashPair<Node>, Double> dists) throws Graph.NoEdgeException {
        HashPair<Node> p = new HashPair<Node>(root, node);
        if (dists.containsKey(p)) {
            return dists.get(p);
        }
        double maxDist = 0.0;
        for (Node n : tree.getAdjacencies(node)) {
            if (n == root) continue;
            double d = ReRootedTree.dist(tree, node, n, dists);
            maxDist = Math.max(maxDist, d);
        }
        double dist = tree.getEdgeLength(node, root) + maxDist;
        dists.put(p, dist);
        return dist;
    }

    private class ReRootedNode
    implements Node {
        private final Node source;
        private List<Node> children;
        private Taxon taxon;
        private Node parent;
        private double height;
        private double length;
        private Edge edge = null;
        private AttributableHelper helper = null;

        public ReRootedNode(Node source, Taxon taxon) {
            this.source = source;
            this.children = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        public ReRootedNode(Node source, List<? extends Node> children) {
            this.source = source;
            this.children = Collections.unmodifiableList(new ArrayList<Node>(children));
            this.taxon = null;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }

        @Override
        public int getDegree() {
            return this.children.size() + (this == ReRootedTree.this.rootNode ? 0 : 1);
        }

        public void setTaxon(Taxon to) {
            this.taxon = to;
        }

        public Edge getEdge() {
            if (this.edge == null) {
                this.edge = new BaseEdge(){

                    @Override
                    public double getLength() {
                        return ReRootedNode.this.length;
                    }
                };
            }
            return this.edge;
        }

        public List<Node> getAdjacencies() {
            ArrayList<Node> adjacencies = new ArrayList<Node>();
            if (this.children != null) {
                adjacencies.addAll(this.children);
            }
            if (this.parent != null) {
                adjacencies.add(this.parent);
            }
            return adjacencies;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public void setAttribute(String name, Object value) {
            if (this.source == null) {
                if (this.helper == null) {
                    this.helper = new AttributableHelper();
                }
                this.helper.setAttribute(name, value);
            } else {
                this.source.setAttribute(name, value);
            }
        }

        @Override
        public Object getAttribute(String name) {
            if (this.source == null) {
                if (this.helper == null) {
                    return null;
                }
                return this.helper.getAttribute(name);
            }
            return this.source.getAttribute(name);
        }

        @Override
        public void removeAttribute(String name) {
            if (this.source == null) {
                if (this.helper != null) {
                    this.helper.removeAttribute(name);
                }
            } else {
                this.source.removeAttribute(name);
            }
        }

        @Override
        public Set<String> getAttributeNames() {
            if (this.source == null) {
                if (this.helper == null) {
                    return Collections.emptySet();
                }
                return this.helper.getAttributeNames();
            }
            return this.source.getAttributeNames();
        }

        @Override
        public Map<String, Object> getAttributeMap() {
            if (this.source == null) {
                if (this.helper == null) {
                    return Collections.emptyMap();
                }
                return this.helper.getAttributeMap();
            }
            return this.source.getAttributeMap();
        }
    }
}

