/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.AbstractRootedTree;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.BaseNode;
import jebl.evolution.trees.RootedTree;
import jebl.util.AttributableHelper;

public final class RootedSubtree
extends AbstractRootedTree {
    private AttributableHelper helper = null;
    protected RootedSubtreeNode rootNode = null;
    protected final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Map<Taxon, Node> externalNodes = new LinkedHashMap<Taxon, Node>();
    private boolean heightsKnown = false;
    private boolean lengthsKnown = false;
    private boolean hasHeights = false;
    private boolean hasLengths = false;
    private boolean conceptuallyUnrooted = false;

    public RootedSubtree(RootedTree tree, Set<Taxon> includedTaxa) {
        this.createNodes(tree, tree.getRootNode(), includedTaxa);
    }

    private RootedSubtreeNode createNodes(RootedTree tree, Node node, Set<Taxon> includedTaxa) {
        RootedSubtreeNode newNode;
        if (tree.isExternal(node)) {
            newNode = this.createExternalNode(tree.getTaxon(node), includedTaxa);
        } else {
            ArrayList<RootedSubtreeNode> children = new ArrayList<RootedSubtreeNode>();
            for (Node child : tree.getChildren(node)) {
                RootedSubtreeNode newChild = this.createNodes(tree, child, includedTaxa);
                if (newChild == null) continue;
                children.add(newChild);
            }
            if (children.size() > 1) {
                newNode = this.createInternalNode(children);
            } else {
                if (children.size() == 1) {
                    return (RootedSubtreeNode)children.get(0);
                }
                newNode = null;
            }
        }
        if (newNode != null) {
            for (Map.Entry<String, Object> e : node.getAttributeMap().entrySet()) {
                newNode.setAttribute(e.getKey(), e.getValue());
            }
            this.setHeight(newNode, tree.getHeight(node));
        }
        return newNode;
    }

    private RootedSubtreeNode createExternalNode(Taxon taxon, Set<Taxon> includedTaxa) {
        if (this.getTaxa().contains(taxon)) {
            throw new IllegalArgumentException("duplicate taxon " + taxon.getName());
        }
        if (!includedTaxa.contains(taxon)) {
            return null;
        }
        RootedSubtreeNode node = new RootedSubtreeNode(taxon);
        this.externalNodes.put(taxon, node);
        return node;
    }

    private RootedSubtreeNode createInternalNode(List<? extends Node> children) {
        RootedSubtreeNode node = new RootedSubtreeNode(children);
        for (Node node2 : children) {
            ((RootedSubtreeNode)node2).setParent(node);
        }
        this.internalNodes.add(node);
        this.rootNode = node;
        return node;
    }

    public void setHeight(Node node, double height) {
        this.lengthsKnown = false;
        this.heightsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((RootedSubtreeNode)node).setHeight(height);
    }

    public void setLength(Node node, double length) {
        this.heightsKnown = false;
        this.lengthsKnown = true;
        this.hasLengths = true;
        this.hasHeights = true;
        ((RootedSubtreeNode)node).setLength(length);
    }

    @Override
    public List<Node> getChildren(Node node) {
        return new ArrayList<Node>(((RootedSubtreeNode)node).getChildren());
    }

    @Override
    public boolean hasHeights() {
        return this.hasHeights;
    }

    @Override
    public double getHeight(Node node) {
        if (!this.hasHeights) {
            throw new IllegalArgumentException("This tree has no node heights");
        }
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((RootedSubtreeNode)node).getHeight();
    }

    @Override
    public boolean hasLengths() {
        return this.hasLengths;
    }

    @Override
    public double getLength(Node node) {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("This tree has no branch lengths");
        }
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((RootedSubtreeNode)node).getLength();
    }

    @Override
    public boolean isHeightsKnown() {
        return this.heightsKnown;
    }

    @Override
    public boolean isLengthsKnown() {
        return this.lengthsKnown;
    }

    @Override
    public Node getParent(Node node) {
        if (!(node instanceof RootedSubtreeNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of RootedSubtreeNode");
        }
        return ((RootedSubtreeNode)node).getParent();
    }

    public Edge getParentEdge(Node node) {
        if (!(node instanceof RootedSubtreeNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of RootedSubtreeNode");
        }
        return ((RootedSubtreeNode)node).getEdge();
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return new LinkedHashSet<Node>(this.externalNodes.values());
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(this.externalNodes.keySet());
    }

    @Override
    public Taxon getTaxon(Node node) {
        if (!(node instanceof RootedSubtreeNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of RootedSubtreeNode");
        }
        return ((RootedSubtreeNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        if (!(node instanceof RootedSubtreeNode)) {
            throw new IllegalArgumentException("Node, " + node.toString() + " is not an instance of RootedSubtreeNode");
        }
        boolean result = ((RootedSubtreeNode)node).getChildren().size() == 0;
        return result;
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.externalNodes.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        RootedSubtreeNode node = (RootedSubtreeNode)this.externalNodes.get(from);
        if (node == null) {
            throw new IllegalArgumentException("Unknown taxon " + from + "; can't rename to " + to);
        }
        node.setTaxa(to);
        this.externalNodes.remove(from);
        this.externalNodes.put(to, node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node adjNode : this.getAdjacencies(node)) {
            edges.add(((RootedSubtreeNode)adjNode).getEdge());
        }
        return edges;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((RootedSubtreeNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((RootedSubtreeNode)node1).getParent() == node2) {
            return ((RootedSubtreeNode)node1).getEdge();
        }
        if (((RootedSubtreeNode)node2).getParent() == node1) {
            return ((RootedSubtreeNode)node2).getEdge();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        if (((RootedSubtreeNode)node1).getParent() == node2) {
            if (this.heightsKnown) {
                return ((RootedSubtreeNode)node2).getHeight() - ((RootedSubtreeNode)node1).getHeight();
            }
            return ((RootedSubtreeNode)node1).getLength();
        }
        if (((RootedSubtreeNode)node2).getParent() == node1) {
            if (this.heightsKnown) {
                return ((RootedSubtreeNode)node1).getHeight() - ((RootedSubtreeNode)node2).getHeight();
            }
            return ((RootedSubtreeNode)node2).getLength();
        }
        throw new Graph.NoEdgeException();
    }

    @Override
    public Node[] getNodes(Edge edge) {
        for (Node node : this.getNodes()) {
            if (((RootedSubtreeNode)node).getEdge() != edge) continue;
            return new Node[]{node, ((RootedSubtreeNode)node).getParent()};
        }
        return null;
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.internalNodes);
        nodes.addAll(this.externalNodes.values());
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((RootedSubtreeNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getExternalNodes()) {
            edges.add(((RootedSubtreeNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (Node node : this.getInternalNodes()) {
            if (node == this.getRootNode()) continue;
            edges.add(((RootedSubtreeNode)node).getEdge());
        }
        return edges;
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            int deg = node.getDegree();
            if (deg != degree) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private void calculateNodeHeights() {
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Can't calculate node heights because branch lengths not known");
        }
        this.nodeLengthsToHeights(this.rootNode, 0.0);
        double maxHeight = 0.0;
        for (Node externalNode : this.getExternalNodes()) {
            if (!(((RootedSubtreeNode)externalNode).getHeight() > maxHeight)) continue;
            maxHeight = ((RootedSubtreeNode)externalNode).getHeight();
        }
        for (Node node : this.getNodes()) {
            ((RootedSubtreeNode)node).setHeight(maxHeight - ((RootedSubtreeNode)node).getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(RootedSubtreeNode node, double height) {
        double newHeight = height;
        if (node.getLength() > 0.0) {
            newHeight += node.getLength();
        }
        node.setHeight(newHeight);
        for (Node child : node.getChildren()) {
            this.nodeLengthsToHeights((RootedSubtreeNode)child, newHeight);
        }
    }

    protected void calculateBranchLengths() {
        if (!this.hasLengths) {
            throw new IllegalArgumentException("Can't calculate branch lengths because node heights not known");
        }
        this.nodeHeightsToLengths(this.rootNode, this.getHeight(this.rootNode));
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(RootedSubtreeNode node, double height) {
        double h = node.getHeight();
        node.setLength(h >= 0.0 ? height - h : 1.0);
        for (Node child : node.getChildren()) {
            this.nodeHeightsToLengths((RootedSubtreeNode)child, node.getHeight());
        }
    }

    public void setConceptuallyUnrooted(boolean intent) {
        this.conceptuallyUnrooted = intent;
    }

    @Override
    public boolean conceptuallyUnrooted() {
        return this.conceptuallyUnrooted;
    }

    @Override
    public boolean isRoot(Node node) {
        return node == this.rootNode;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    private class RootedSubtreeNode
    extends BaseNode {
        private List<Node> children;
        private Taxon taxon;
        private Node parent;
        private double height;
        private double length;
        private Edge edge = null;

        public RootedSubtreeNode(Taxon taxon) {
            this.children = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        public RootedSubtreeNode(List<? extends Node> children) {
            this.children = Collections.unmodifiableList(new ArrayList<Node>(children));
            this.taxon = null;
        }

        public void removeChild(Node node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.remove(node);
            this.children = Collections.unmodifiableList(c);
        }

        public void addChild(RootedSubtreeNode node) {
            ArrayList<Node> c = new ArrayList<Node>(this.children);
            c.add(node);
            node.setParent(this);
            this.children = Collections.unmodifiableList(c);
        }

        public void replaceChildren(List<RootedSubtreeNode> nodes) {
            for (RootedSubtreeNode n : nodes) {
                n.setParent(this);
            }
            this.children = Collections.unmodifiableList(new ArrayList<RootedSubtreeNode>(nodes));
        }

        void swapChildren(int i0, int i1) {
            ArrayList<Node> nc = new ArrayList<Node>(this.children);
            if (i0 < 0 || i0 >= nc.size() || i1 < 0 || i1 >= nc.size()) {
                throw new IllegalArgumentException("Tried to swap children (" + i0 + "," + i1 + ") on node with " + nc.size() + " children");
            }
            Node ni0 = nc.get(i0);
            nc.set(i0, nc.get(i1));
            nc.set(i1, ni0);
            this.children = Collections.unmodifiableList(nc);
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double height) {
            this.height = height;
        }

        public double getLength() {
            return this.length;
        }

        public void setLength(double length) {
            this.length = length;
        }

        @Override
        public int getDegree() {
            return this.children.size() + (this == RootedSubtree.this.rootNode ? 0 : 1);
        }

        public void setTaxa(Taxon to) {
            this.taxon = to;
        }

        public Edge getEdge() {
            if (this.edge == null) {
                this.edge = new BaseEdge(){

                    @Override
                    public double getLength() {
                        return RootedSubtreeNode.this.length;
                    }
                };
            }
            return this.edge;
        }

        public List<Node> getAdjacencies() {
            ArrayList<Node> adjacencies = new ArrayList<Node>();
            if (this.children != null) {
                adjacencies.addAll(this.children);
            }
            if (this.parent != null) {
                adjacencies.add(this.parent);
            }
            return adjacencies;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }
    }
}

