/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.MissingTaxonException;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;

public class RootedTreeUtils {
    private RootedTreeUtils() {
    }

    public static final int getTipCount(RootedTree tree, Node node) {
        return tree.getExternalNodeCount(node);
    }

    public static double getMinTipHeight(RootedTree tree, Node node) {
        if (tree.isExternal(node)) {
            return tree.getHeight(node);
        }
        double minTipHeight = Double.MAX_VALUE;
        for (Node child : tree.getChildren(node)) {
            double h = RootedTreeUtils.getMinTipHeight(tree, child);
            if (!(h < minTipHeight)) continue;
            minTipHeight = h;
        }
        return minTipHeight;
    }

    public static double getMaxTipHeight(RootedTree tree, Node node) {
        if (tree.isExternal(node)) {
            return tree.getHeight(node);
        }
        double maxTipHeight = -1.7976931348623157E308;
        for (Node child : tree.getChildren(node)) {
            double h = RootedTreeUtils.getMaxTipHeight(tree, child);
            if (!(h > maxTipHeight)) continue;
            maxTipHeight = h;
        }
        return maxTipHeight;
    }

    public static boolean isUltrametric(RootedTree tree, double tolerance) {
        for (Node node : tree.getExternalNodes()) {
            if (!(Math.abs(tree.getHeight(node)) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBinary(RootedTree tree) {
        for (Node node : tree.getInternalNodes()) {
            if (tree.getChildren(node).size() <= 2) continue;
            return false;
        }
        return true;
    }

    public static Set<Node> getTipsForTaxa(RootedTree tree, Collection<Taxon> taxa) throws MissingTaxonException {
        LinkedHashSet<Node> tipNodes = new LinkedHashSet<Node>();
        for (Taxon taxon : taxa) {
            Node node = tree.getNode(taxon);
            if (node == null) {
                throw new MissingTaxonException(taxon);
            }
            tipNodes.add(node);
        }
        return tipNodes;
    }

    public static Set<Node> getDescendantTips(RootedTree tree, Node node) {
        LinkedHashSet<Node> tipNodes = new LinkedHashSet<Node>();
        RootedTreeUtils.getDescendantTips(tree, node, tipNodes);
        return tipNodes;
    }

    private static void getDescendantTips(RootedTree tree, Node node, Set<Node> tipNodes) {
        for (Node child : tree.getChildren(node)) {
            if (tree.isExternal(child)) {
                tipNodes.add(child);
                continue;
            }
            RootedTreeUtils.getDescendantTips(tree, child, tipNodes);
        }
    }

    public static Node getCommonAncestorNode(RootedTree tree, Set<Node> tipNodes) {
        if (tipNodes.size() == 0) {
            throw new IllegalArgumentException("No leaf nodes selected");
        }
        if (tipNodes.size() == 1) {
            return tipNodes.iterator().next();
        }
        Node[] mrca = new Node[]{null};
        RootedTreeUtils.getCommonAncestorNode(tree, tree.getRootNode(), tipNodes, mrca);
        return mrca[0];
    }

    private static int getCommonAncestorNode(RootedTree tree, Node node, Set<Node> tipNodes, Node[] mrca) {
        int matches = 0;
        for (Node child : tree.getChildren(node)) {
            if (tipNodes.contains(child)) {
                ++matches;
            }
            if (tree.isExternal(child)) continue;
            matches += RootedTreeUtils.getCommonAncestorNode(tree, child, tipNodes, mrca);
            if (mrca[0] == null) continue;
            return matches;
        }
        if (matches == tipNodes.size()) {
            mrca[0] = node;
        }
        return matches;
    }

    public static boolean isMonophyletic(RootedTree tree, Set<Node> tipNodes) {
        if (tipNodes.size() == 0) {
            throw new IllegalArgumentException("No tip nodes selected");
        }
        if (tipNodes.size() == 1) {
            return true;
        }
        if (tipNodes.size() == tree.getExternalNodes().size()) {
            return true;
        }
        int[] matchCount = new int[]{0};
        int[] tipCount = new int[]{0};
        Boolean result = RootedTreeUtils.isMonophyletic(tree, tree.getRootNode(), tipNodes, matchCount, tipCount);
        if (result != null) {
            return result;
        }
        return false;
    }

    private static Boolean isMonophyletic(RootedTree tree, Node node, Set<Node> tipNodes, int[] matchCount, int[] tipCount) {
        int mc = 0;
        int tc = 0;
        for (Node child : tree.getChildren(node)) {
            if (tree.isExternal(child)) {
                if (tipNodes.contains(child)) {
                    ++mc;
                }
                ++tc;
                continue;
            }
            Boolean result = RootedTreeUtils.isMonophyletic(tree, child, tipNodes, matchCount, tipCount);
            if (result != null) {
                return result;
            }
            mc += matchCount[0];
            tc += tipCount[0];
        }
        matchCount[0] = mc;
        tipCount[0] = tc;
        if (mc == tc && tc == tipNodes.size()) {
            return Boolean.TRUE;
        }
        if (mc != 0 && mc != tc) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static String uniqueNewick(RootedTree tree, Node node) {
        if (tree.isExternal(node)) {
            return tree.getTaxon(node).getName();
        }
        StringBuffer buffer = new StringBuffer("(");
        ArrayList<String> subtrees = new ArrayList<String>();
        for (Node child : tree.getChildren(node)) {
            subtrees.add(RootedTreeUtils.uniqueNewick(tree, child));
        }
        Collections.sort(subtrees);
        for (int i = 0; i < subtrees.size(); ++i) {
            buffer.append((String)subtrees.get(i));
            if (i >= subtrees.size() - 1) continue;
            buffer.append(",");
        }
        buffer.append(")");
        return buffer.toString();
    }

    public static boolean equal(RootedTree tree1, RootedTree tree2) {
        return RootedTreeUtils.uniqueNewick(tree1, tree1.getRootNode()).equals(RootedTreeUtils.uniqueNewick(tree2, tree2.getRootNode()));
    }
}

