/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.graphs.Edge;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.BaseEdge;
import jebl.evolution.trees.BaseNode;
import jebl.evolution.trees.Tree;
import jebl.util.AttributableHelper;
import jebl.util.HashPair;

public final class SimpleTree
implements Tree {
    private AttributableHelper helper = null;
    private final Set<Node> internalNodes = new LinkedHashSet<Node>();
    private final Map<Taxon, Node> externalNodes = new LinkedHashMap<Taxon, Node>();
    Map<HashPair, Edge> edges = new LinkedHashMap<HashPair, Edge>();

    public SimpleTree() {
    }

    public SimpleTree(Tree tree) {
        try {
            this.createTree(tree, tree.getExternalNodes().iterator().next(), null);
        }
        catch (Graph.NoEdgeException e) {
            throw new IllegalArgumentException("BUG: invalid tree");
        }
    }

    public Node createExternalNode(Taxon taxon) {
        SimpleNode node = new SimpleNode(taxon);
        this.externalNodes.put(taxon, node);
        return node;
    }

    public Node createInternalNode(List<Node> adjacencies) {
        SimpleNode node = new SimpleNode(adjacencies);
        this.internalNodes.add(node);
        for (Node c : adjacencies) {
            ((SimpleNode)c).addAdjacency(node);
        }
        return node;
    }

    public void setEdgeLength(Node node1, Node node2, double length) {
        assert (this.getAdjacencies(node1).contains(node2) && this.getAdjacencies(node2).contains(node1) && length >= 0.0);
        SimpleEdge edge = new SimpleEdge(node1, node2, length);
        this.edges.put(new HashPair<Node>(node1, node2), edge);
        this.edges.put(new HashPair<Node>(node2, node1), edge);
    }

    public void setEdgeLength(Edge edge, double length) {
        ((SimpleEdge)edge).length = length;
    }

    public void addEdge(Node node1, Node node2, double length) {
        assert (!this.getAdjacencies(node1).contains(node2));
        ((SimpleNode)node1).addAdjacency(node2);
        ((SimpleNode)node2).addAdjacency(node1);
        this.setEdgeLength(node1, node2, length);
    }

    private Node createTree(Tree source, Node node, Node root) throws Graph.NoEdgeException {
        Node h = source.isExternal(node) ? this.createExternalNode(source.getTaxon(node)) : this.createInternalNode(new ArrayList<Node>());
        List<Node> adjacencies = source.getAdjacencies(node);
        for (Node c : adjacencies) {
            if (c == root) continue;
            Node n = this.createTree(source, c, node);
            this.addEdge(h, n, source.getEdgeLength(node, c));
        }
        return h;
    }

    @Override
    public List<Edge> getEdges(Node node) {
        List<Node> adjacencies = this.getAdjacencies(node);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (Node adjNode : adjacencies) {
            try {
                edges.add(this.getEdge(node, adjNode));
            }
            catch (Graph.NoEdgeException noEdgeException) {}
        }
        return edges;
    }

    @Override
    public List<Node> getAdjacencies(Node node) {
        return ((SimpleNode)node).getAdjacencies();
    }

    @Override
    public Edge getEdge(Node node1, Node node2) throws Graph.NoEdgeException {
        Edge edge = this.edges.get(new HashPair<Node>(node1, node2));
        if (edge == null) {
            throw new Graph.NoEdgeException();
        }
        return edge;
    }

    @Override
    public Set<Node> getExternalNodes() {
        return new LinkedHashSet<Node>(this.externalNodes.values());
    }

    @Override
    public Set<Node> getInternalNodes() {
        return new LinkedHashSet<Node>(this.internalNodes);
    }

    @Override
    public Set<Taxon> getTaxa() {
        return new LinkedHashSet<Taxon>(this.externalNodes.keySet());
    }

    @Override
    public Taxon getTaxon(Node node) {
        return ((SimpleNode)node).getTaxon();
    }

    @Override
    public boolean isExternal(Node node) {
        return node.getDegree() == 1;
    }

    public boolean isExternal(Edge edge) {
        return ((SimpleEdge)edge).isExternal();
    }

    @Override
    public Node getNode(Taxon taxon) {
        return this.externalNodes.get(taxon);
    }

    @Override
    public void renameTaxa(Taxon from, Taxon to) {
        SimpleNode node = (SimpleNode)this.externalNodes.get(from);
        node.setTaxa(to);
        this.externalNodes.remove(from);
        this.externalNodes.put(to, node);
    }

    @Override
    public double getEdgeLength(Node node1, Node node2) throws Graph.NoEdgeException {
        return this.getEdge(node1, node2).getLength();
    }

    @Override
    public Node[] getNodes(Edge edge) {
        return new Node[]{((SimpleEdge)edge).getNode1(), ((SimpleEdge)edge).getNode2()};
    }

    @Override
    public Set<Node> getNodes() {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>(this.internalNodes);
        nodes.addAll(this.externalNodes.values());
        return nodes;
    }

    @Override
    public Set<Edge> getEdges() {
        return new LinkedHashSet<Edge>(this.edges.values());
    }

    @Override
    public Set<Node> getNodes(int degree) {
        LinkedHashSet<Node> nodes = new LinkedHashSet<Node>();
        for (Node node : this.getNodes()) {
            if (((SimpleNode)node).getDegree() != degree) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public Set<Edge> getExternalEdges() {
        LinkedHashSet<Edge> externalEdges = new LinkedHashSet<Edge>();
        for (Edge edge : this.getEdges()) {
            if (!((SimpleEdge)edge).isExternal()) continue;
            externalEdges.add(edge);
        }
        return externalEdges;
    }

    @Override
    public Set<Edge> getInternalEdges() {
        LinkedHashSet<Edge> internalEdges = new LinkedHashSet<Edge>();
        for (Edge edge : this.getEdges()) {
            if (((SimpleEdge)edge).isExternal()) continue;
            internalEdges.add(edge);
        }
        return internalEdges;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.helper == null) {
            this.helper = new AttributableHelper();
        }
        this.helper.setAttribute(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.helper == null) {
            return null;
        }
        return this.helper.getAttribute(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.helper != null) {
            this.helper.removeAttribute(name);
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        if (this.helper == null) {
            return Collections.emptySet();
        }
        return this.helper.getAttributeNames();
    }

    @Override
    public Map<String, Object> getAttributeMap() {
        if (this.helper == null) {
            return Collections.emptyMap();
        }
        return this.helper.getAttributeMap();
    }

    final class SimpleNode
    extends BaseNode {
        private List<Node> adjacencies;
        private Taxon taxon;

        private SimpleNode(Taxon taxon) {
            this.adjacencies = Collections.unmodifiableList(new ArrayList());
            this.taxon = taxon;
        }

        private SimpleNode(List<Node> adjacencies) {
            this.adjacencies = Collections.unmodifiableList(adjacencies);
            this.taxon = null;
        }

        public void addAdjacency(Node node) {
            ArrayList<Node> a = new ArrayList<Node>(this.adjacencies);
            a.add(node);
            this.adjacencies = Collections.unmodifiableList(a);
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        public int getDegree() {
            return this.adjacencies == null ? 0 : this.adjacencies.size();
        }

        public List<Node> getAdjacencies() {
            return this.adjacencies;
        }

        public void setTaxa(Taxon to) {
            this.taxon = to;
        }
    }

    final class SimpleEdge
    extends BaseEdge {
        private double length;
        Node node1;
        Node node2;

        private SimpleEdge(Node node1, Node node2, double length) {
            this.node1 = node1;
            this.node2 = node2;
            this.length = length;
        }

        public Node getNode1() {
            return this.node1;
        }

        public Node getNode2() {
            return this.node2;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        private boolean isExternal() {
            return this.node1.getDegree() == 1 || this.node2.getDegree() == 1;
        }
    }
}

