/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.Arrays;
import java.util.List;
import jebl.evolution.distances.DistanceMatrix;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ClusteringTreeBuilder;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.Tree;

class UPGMATreeBuilder
extends ClusteringTreeBuilder {
    private final SimpleRootedTree tree = new SimpleRootedTree();

    public UPGMATreeBuilder(DistanceMatrix distanceMatrix) {
        super(distanceMatrix, 2);
    }

    protected Tree getTree() {
        return this.tree;
    }

    @Override
    protected Node createExternalNode(Taxon taxon) {
        return this.tree.createExternalNode(taxon);
    }

    @Override
    protected Node createInternalNode(Node[] nodes, double[] distances) {
        List<Node> a = Arrays.asList(nodes);
        SimpleRootedTree.SimpleRootedNode node = this.tree.createInternalNode(a);
        this.tree.setHeight(node, distances[0]);
        return node;
    }

    @Override
    protected double[] joinClusters() {
        Double d = this.getDist(this.besti, this.bestj) / 2.0;
        return new double[]{d};
    }

    @Override
    protected double updatedDistance(int k) {
        int i = this.besti;
        int j = this.bestj;
        int ai = this.alias[i];
        int aj = this.alias[j];
        double tipSum = this.tipCount[ai] + this.tipCount[aj];
        return (double)this.tipCount[ai] / tipSum * this.getDist(k, i) + (double)this.tipCount[aj] / tipSum * this.getDist(k, j);
    }
}

