/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.treesimulation;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jebl.evolution.coalescent.ConstantPopulation;
import jebl.evolution.coalescent.ExponentialGrowth;
import jebl.evolution.coalescent.LogisticGrowth;
import jebl.evolution.graphs.Node;
import jebl.evolution.io.NexusExporter;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.SimpleRootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.treesimulation.CoalescentIntervalGenerator;
import jebl.evolution.treesimulation.IntervalGenerator;
import jebl.math.Random;

public class TreeSimulator {
    private List<Taxon> taxa;
    private String heightAttributeName;

    public TreeSimulator(String taxonPrefix, int taxonCount) {
        this(taxonPrefix, new int[]{taxonCount}, new double[]{0.0});
    }

    public TreeSimulator(String taxonPrefix, double[] samplingTimes) {
        ArrayList<Taxon> taxonList = new ArrayList<Taxon>();
        for (int i = 0; i < samplingTimes.length; ++i) {
            Taxon taxon = Taxon.getTaxon(taxonPrefix + Integer.toString(i + 1) + "_" + Double.toString(samplingTimes[i]));
            taxon.setAttribute("height", samplingTimes[i]);
            taxonList.add(taxon);
        }
        this.setTaxa(taxonList, "height");
    }

    public TreeSimulator(String taxonPrefix, int[] samplingCounts, double[] samplingTimes) {
        ArrayList<Taxon> taxonList = new ArrayList<Taxon>();
        int k = 0;
        for (int i = 0; i < samplingCounts.length; ++i) {
            for (int j = 0; j < samplingCounts[i]; ++j) {
                Taxon taxon = Taxon.getTaxon(taxonPrefix + Integer.toString(k + 1) + "_" + Double.toString(samplingTimes[i]));
                taxon.setAttribute("height", samplingTimes[i]);
                taxonList.add(taxon);
                ++k;
            }
        }
        this.setTaxa(taxonList, "height");
    }

    public TreeSimulator(Collection<Taxon> taxa, String heightAttributeName) {
        ArrayList<Taxon> taxonList = new ArrayList<Taxon>();
        for (Taxon taxon : taxa) {
            taxonList.add(taxon);
        }
        this.setTaxa(taxonList, heightAttributeName);
    }

    private void setTaxa(List<Taxon> taxa, final String heightAttributeName) {
        this.taxa = taxa;
        this.heightAttributeName = heightAttributeName;
        Collections.sort(this.taxa, new Comparator<Taxon>(){

            @Override
            public int compare(Taxon taxon1, Taxon taxon2) {
                double height1 = 0.0;
                double height2 = 0.0;
                Double attr = (Double)taxon1.getAttribute(heightAttributeName);
                if (attr != null) {
                    height1 = attr;
                }
                if ((attr = (Double)taxon2.getAttribute(heightAttributeName)) != null) {
                    height2 = attr;
                }
                return Double.compare(height1, height2);
            }
        });
    }

    public RootedTree simulate(IntervalGenerator intervalGenerator) {
        return this.simulate(intervalGenerator, false);
    }

    public RootedTree simulate(IntervalGenerator intervalGenerator, boolean medianHeights) {
        SimpleRootedTree tree = new SimpleRootedTree();
        Node[] tipNodes = new Node[this.taxa.size()];
        int i = 0;
        for (Taxon taxon : this.taxa) {
            Node tip = tree.createExternalNode(taxon);
            tree.setHeight(tip, (Double)taxon.getAttribute(this.heightAttributeName));
            tipNodes[i] = tip;
            ++i;
        }
        ArrayList<Node> activeNodes = new ArrayList<Node>();
        double currentHeight = 0.0;
        double nextHeight = 0.0;
        int nextSampleNode = 0;
        boolean hasMoreSamples = true;
        while (true) {
            if (hasMoreSamples && (activeNodes.size() < 2 || currentHeight >= nextHeight)) {
                currentHeight = tree.getHeight(tipNodes[nextSampleNode]);
                activeNodes.add(tipNodes[nextSampleNode]);
                if (++nextSampleNode < tipNodes.length) {
                    nextHeight = tree.getHeight(tipNodes[nextSampleNode]);
                    continue;
                }
                hasMoreSamples = false;
                continue;
            }
            double U = !medianHeights ? Random.nextDouble() : 0.5;
            currentHeight += intervalGenerator.getInterval(U, activeNodes.size(), currentHeight);
            if (!hasMoreSamples || currentHeight < nextHeight) {
                Node leftNode = (Node)activeNodes.remove(Random.nextInt(activeNodes.size()));
                Node rightNode = (Node)activeNodes.remove(Random.nextInt(activeNodes.size()));
                Node node = this.coalesce(leftNode, rightNode, tree, currentHeight);
                activeNodes.add(node);
            }
            if (!hasMoreSamples && activeNodes.size() <= 1) break;
        }
        return tree;
    }

    private Node coalesce(Node leftNode, Node rightNode, SimpleRootedTree tree, double height) {
        SimpleRootedTree.SimpleRootedNode node = null;
        node = tree.createInternalNode(Arrays.asList(leftNode, rightNode));
        tree.setHeight(node, height);
        return node;
    }

    public static void main(String[] args) {
        double[] samplingTimes = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 5.0, 5.0, 5.0, 5.0, 5.0};
        LogisticGrowth logisticGrowth = new LogisticGrowth();
        logisticGrowth.setN0(10.0);
        logisticGrowth.setGrowthRate(2.0);
        logisticGrowth.setTime50(5.0);
        ExponentialGrowth exponentialGrowth = new ExponentialGrowth();
        exponentialGrowth.setN0(10.0);
        exponentialGrowth.setGrowthRate(0.1);
        ConstantPopulation constantPopulation = new ConstantPopulation();
        constantPopulation.setN0(10.0);
        CoalescentIntervalGenerator intervals = new CoalescentIntervalGenerator(exponentialGrowth);
        TreeSimulator sim = new TreeSimulator("tip", samplingTimes);
        int REPLICATE_COUNT = 10000;
        try {
            Tree[] trees = new Tree[REPLICATE_COUNT];
            System.err.println("Simulating " + REPLICATE_COUNT + " trees of " + samplingTimes.length + " tips:");
            System.err.print("[");
            for (int i = 0; i < REPLICATE_COUNT; ++i) {
                trees[i] = sim.simulate(intervals, true);
                if (i == 0 || i % 100 != 0) continue;
                System.err.print(".");
            }
            System.err.println("]");
            FileWriter writer = new FileWriter("simulated.trees");
            NexusExporter exporter = new NexusExporter(writer);
            exporter.exportTrees(Arrays.asList(trees));
            ((Writer)writer).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

