/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import jebl.math.MultivariateFunction;

public interface MinimiserMonitor {
    public void updateProgress(double var1);

    public void newMinimum(double var1, double[] var3, MultivariateFunction var4);

    public static class Utils {
        private Utils() {
        }

        public static final MinimiserMonitor createSimpleMonitor(PrintWriter output) {
            return new Simple(output);
        }

        public static final MinimiserMonitor createSplitMonitor(MinimiserMonitor a, MinimiserMonitor b) {
            return new Split(a, b);
        }

        public static final MinimiserMonitor createSystemOuptutMonitor() {
            return SystemOutput.INSTANCE;
        }

        public static final MinimiserMonitor createSystemErrorMonitor() {
            return SystemError.INSTANCE;
        }

        public static final MinimiserMonitor createStringMonitor() {
            return new StringMonitor();
        }

        public static final MinimiserMonitor createNullMonitor() {
            return NullMonitor.INSTANCE;
        }

        private static class Simple
        implements MinimiserMonitor {
            PrintWriter output_;

            Simple(PrintWriter output) {
                this.output_ = output;
            }

            @Override
            public void updateProgress(double progress) {
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction mf) {
                this.output_.println("New Minimum:" + value);
            }
        }

        private static class Split
        implements MinimiserMonitor {
            private final MinimiserMonitor a_;
            private final MinimiserMonitor b_;

            public Split(MinimiserMonitor a, MinimiserMonitor b) {
                this.a_ = a;
                this.b_ = b;
            }

            @Override
            public void updateProgress(double progress) {
                this.a_.updateProgress(progress);
                this.b_.updateProgress(progress);
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction mf) {
                this.a_.newMinimum(value, parameterValues, mf);
                this.b_.newMinimum(value, parameterValues, mf);
            }
        }

        private static class SystemOutput
        implements MinimiserMonitor {
            static final SystemOutput INSTANCE = new SystemOutput();

            private SystemOutput() {
            }

            @Override
            public void updateProgress(double progress) {
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction mf) {
                System.out.println("New Minimum:" + value);
            }
        }

        private static class SystemError
        implements MinimiserMonitor {
            static final SystemError INSTANCE = new SystemError();

            private SystemError() {
            }

            @Override
            public void updateProgress(double progress) {
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction mf) {
                System.err.println("New Minimum:" + value);
            }
        }

        private static final class StringMonitor
        implements MinimiserMonitor {
            private final StringWriter sw_ = new StringWriter();
            private final PrintWriter pw_ = new PrintWriter((Writer)this.sw_, true);

            @Override
            public void updateProgress(double progress) {
                this.pw_.println("Update Progress:" + progress);
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction beingOptimized) {
                this.pw_.println("New Minimum:" + value);
            }

            public String toString() {
                return this.sw_.toString();
            }
        }

        private static final class NullMonitor
        implements MinimiserMonitor {
            public static final MinimiserMonitor INSTANCE = new NullMonitor();

            @Override
            public void updateProgress(double progress) {
            }

            @Override
            public void newMinimum(double value, double[] parameterValues, MultivariateFunction beingOptimized) {
            }

            public String toString() {
                return "Null Monitor";
            }
        }
    }
}

