/*
 * Decompiled with CFR 0.152.
 */
package jebl.util;

import java.text.DecimalFormat;

public class NumberFormatter {
    private int sf = -1;
    private int dp = -1;
    private double upperCutoff;
    private double[] cutoffTable;
    private DecimalFormat decimalFormat = new DecimalFormat();
    private DecimalFormat scientificFormat = null;

    public NumberFormatter(int sf) {
        this.setSignificantFigures(sf);
    }

    public void setSignificantFigures(int sf) {
        this.sf = sf;
        this.dp = -1;
        this.upperCutoff = Math.pow(10.0, sf - 1);
        this.cutoffTable = new double[sf];
        long num = 10L;
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            this.cutoffTable[i] = num;
            num *= 10L;
        }
        this.decimalFormat.setGroupingUsed(false);
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(sf - 1);
        this.decimalFormat.setMinimumFractionDigits(sf - 1);
        this.scientificFormat = new DecimalFormat(this.getPattern(sf));
    }

    public int getSignificantFigures() {
        return this.sf;
    }

    public void setDecimalPlaces(int dp) {
        this.dp = dp;
        this.sf = -1;
    }

    public int getDecimalPlaces() {
        return this.dp;
    }

    public String getFormattedValue(double value) {
        if (this.dp < 0 && this.sf < 0) {
            return Double.toString(value);
        }
        int numFractionDigits = 0;
        if (this.dp < 0) {
            double absValue = Math.abs(value);
            if (absValue > this.upperCutoff || absValue < 0.001) {
                return this.scientificFormat.format(value);
            }
            numFractionDigits = this.getNumFractionDigits(value);
        } else {
            numFractionDigits = this.dp;
        }
        this.decimalFormat.setMaximumFractionDigits(numFractionDigits);
        this.decimalFormat.setMinimumFractionDigits(numFractionDigits);
        String labelString = this.decimalFormat.format(value);
        while (labelString.contains(".") && labelString.charAt(labelString.length() - 1) == '0') {
            labelString = labelString.substring(0, labelString.length() - 1);
        }
        if (labelString.endsWith(".")) {
            labelString = labelString.substring(0, labelString.length() - 1);
        }
        return labelString;
    }

    private int getNumFractionDigits(double value) {
        if ((value = Math.abs(value)) < 1.0) {
            return this.sf;
        }
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            if (!(value < this.cutoffTable[i])) continue;
            return this.sf - i - 1;
        }
        return this.sf - 1;
    }

    private String getPattern(int sf) {
        Object pattern = "0.";
        for (int i = 0; i < sf - 1; ++i) {
            pattern = (String)pattern + "#";
        }
        pattern = (String)pattern + "E0";
        return pattern;
    }
}

