/*
 * Decompiled with CFR 0.152.
 */
package lphy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jebl.evolution.sequences.SequenceType;
import lphy.graphicalModel.Func;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.spi.LPhyExtension;

public class LPhyExtensionFactory {
    private static LPhyExtensionFactory factory;
    private final ServiceLoader<LPhyExtension> loader;
    public Map<String, Set<Class<?>>> genDistDictionary;
    public Map<String, Set<Class<?>>> functionDictionary;
    public TreeSet<Class<?>> types = new TreeSet<Class>(Comparator.comparing(Class::getName));
    public Map<String, SequenceType> dataTypeMap;

    private LPhyExtensionFactory() {
        this.loader = ServiceLoader.load(LPhyExtension.class);
        this.registerExtensions(this.loader, null);
    }

    public static synchronized LPhyExtensionFactory getInstance() {
        if (factory == null) {
            factory = new LPhyExtensionFactory();
        }
        return factory;
    }

    public void loadExtension(String fullClsName) {
        this.loader.reload();
        this.registerExtensions(this.loader, fullClsName);
    }

    public List<LPhyExtension> getExtensions() {
        this.loader.reload();
        Iterator<LPhyExtension> extensions = this.loader.iterator();
        ArrayList<LPhyExtension> extList = new ArrayList<LPhyExtension>();
        extensions.forEachRemaining(extList::add);
        return extList;
    }

    private void registerExtensions(ServiceLoader<LPhyExtension> loader, String clsName) {
        this.genDistDictionary = new TreeMap();
        this.functionDictionary = new TreeMap();
        this.dataTypeMap = new ConcurrentHashMap<String, SequenceType>();
        try {
            for (LPhyExtension lPhyExt : loader) {
                if (clsName != null && !lPhyExt.getClass().getName().equalsIgnoreCase(clsName)) continue;
                System.out.println("Registering extension from " + lPhyExt.getClass().getName());
                List<Class<? extends GenerativeDistribution>> genDist = lPhyExt.getDistributions();
                for (Class<? extends GenerativeDistribution> clazz : genDist) {
                    String name = Generator.getGeneratorName(clazz);
                    Set genDistSet = this.genDistDictionary.computeIfAbsent(name, k -> new HashSet());
                    genDistSet.add(clazz);
                    this.types.add(GenerativeDistribution.getReturnType(clazz));
                    Collections.addAll(this.types, Generator.getParameterTypes(clazz, 0));
                    Collections.addAll(this.types, Generator.getReturnType(clazz));
                }
                List<Class<? extends Func>> funcs = lPhyExt.getFunctions();
                for (Class<? extends Func> functionClass : funcs) {
                    String name = Generator.getGeneratorName(functionClass);
                    Set funcSet = this.functionDictionary.computeIfAbsent(name, k -> new HashSet());
                    funcSet.add(functionClass);
                    Collections.addAll(this.types, Generator.getParameterTypes(functionClass, 0));
                    Collections.addAll(this.types, Generator.getReturnType(functionClass));
                }
                Map<String, ? extends SequenceType> map = lPhyExt.getSequenceTypes();
                if (map == null) continue;
                map.forEach(this.dataTypeMap::putIfAbsent);
            }
            System.out.println("\nGenerativeDistribution : " + Arrays.toString(this.genDistDictionary.keySet().toArray()));
            System.out.println("Functions : " + Arrays.toString(this.functionDictionary.keySet().toArray()));
            if (this.genDistDictionary.size() < 1 || this.functionDictionary.size() < 1) {
                throw new RuntimeException("LPhy core did not load properly using SPI mechanism !");
            }
            TreeSet typeNames = this.types.stream().map(Class::getSimpleName).collect(Collectors.toCollection(TreeSet::new));
            System.out.println("LPhy data types : " + typeNames);
            System.out.println("LPhy sequence types : " + Arrays.toString(this.dataTypeMap.values().toArray(new SequenceType[0])));
        }
        catch (ServiceConfigurationError serviceError) {
            System.err.println(serviceError);
            serviceError.printStackTrace();
        }
    }
}

