/*
 * Decompiled with CFR 0.152.
 */
package lphy.bmodeltest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lphy.graphicalModel.MethodInfo;

public class BModelSet {
    ModelSet modelSet;
    int[][] models;
    int[] groupCount;
    int[][] subgroupCount;
    int[] modelID;
    List<Integer>[] mergedModels;
    List<Integer>[] splitModels;
    public static int[][] MODELS = new int[][]{{0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 1, 0}, {0, 0, 0, 0, 1, 1}, {0, 0, 0, 0, 1, 2}, {0, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 1}, {0, 0, 0, 1, 0, 2}, {0, 0, 0, 1, 1, 0}, {0, 0, 0, 1, 1, 1}, {0, 0, 0, 1, 1, 2}, {0, 0, 0, 1, 2, 0}, {0, 0, 0, 1, 2, 1}, {0, 0, 0, 1, 2, 2}, {0, 0, 0, 1, 2, 3}, {0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 2}, {0, 0, 1, 0, 1, 0}, {0, 0, 1, 0, 1, 1}, {0, 0, 1, 0, 1, 2}, {0, 0, 1, 0, 2, 0}, {0, 0, 1, 0, 2, 1}, {0, 0, 1, 0, 2, 2}, {0, 0, 1, 0, 2, 3}, {0, 0, 1, 1, 0, 0}, {0, 0, 1, 1, 0, 1}, {0, 0, 1, 1, 0, 2}, {0, 0, 1, 1, 1, 0}, {0, 0, 1, 1, 1, 1}, {0, 0, 1, 1, 1, 2}, {0, 0, 1, 1, 2, 0}, {0, 0, 1, 1, 2, 1}, {0, 0, 1, 1, 2, 2}, {0, 0, 1, 1, 2, 3}, {0, 0, 1, 2, 0, 0}, {0, 0, 1, 2, 0, 1}, {0, 0, 1, 2, 0, 2}, {0, 0, 1, 2, 0, 3}, {0, 0, 1, 2, 1, 0}, {0, 0, 1, 2, 1, 1}, {0, 0, 1, 2, 1, 2}, {0, 0, 1, 2, 1, 3}, {0, 0, 1, 2, 2, 0}, {0, 0, 1, 2, 2, 1}, {0, 0, 1, 2, 2, 2}, {0, 0, 1, 2, 2, 3}, {0, 0, 1, 2, 3, 0}, {0, 0, 1, 2, 3, 1}, {0, 0, 1, 2, 3, 2}, {0, 0, 1, 2, 3, 3}, {0, 0, 1, 2, 3, 4}, {0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 0, 1}, {0, 1, 0, 0, 0, 2}, {0, 1, 0, 0, 1, 0}, {0, 1, 0, 0, 1, 1}, {0, 1, 0, 0, 1, 2}, {0, 1, 0, 0, 2, 0}, {0, 1, 0, 0, 2, 1}, {0, 1, 0, 0, 2, 2}, {0, 1, 0, 0, 2, 3}, {0, 1, 0, 1, 0, 0}, {0, 1, 0, 1, 0, 1}, {0, 1, 0, 1, 0, 2}, {0, 1, 0, 1, 1, 0}, {0, 1, 0, 1, 1, 1}, {0, 1, 0, 1, 1, 2}, {0, 1, 0, 1, 2, 0}, {0, 1, 0, 1, 2, 1}, {0, 1, 0, 1, 2, 2}, {0, 1, 0, 1, 2, 3}, {0, 1, 0, 2, 0, 0}, {0, 1, 0, 2, 0, 1}, {0, 1, 0, 2, 0, 2}, {0, 1, 0, 2, 0, 3}, {0, 1, 0, 2, 1, 0}, {0, 1, 0, 2, 1, 1}, {0, 1, 0, 2, 1, 2}, {0, 1, 0, 2, 1, 3}, {0, 1, 0, 2, 2, 0}, {0, 1, 0, 2, 2, 1}, {0, 1, 0, 2, 2, 2}, {0, 1, 0, 2, 2, 3}, {0, 1, 0, 2, 3, 0}, {0, 1, 0, 2, 3, 1}, {0, 1, 0, 2, 3, 2}, {0, 1, 0, 2, 3, 3}, {0, 1, 0, 2, 3, 4}, {0, 1, 1, 0, 0, 0}, {0, 1, 1, 0, 0, 1}, {0, 1, 1, 0, 0, 2}, {0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 1}, {0, 1, 1, 0, 1, 2}, {0, 1, 1, 0, 2, 0}, {0, 1, 1, 0, 2, 1}, {0, 1, 1, 0, 2, 2}, {0, 1, 1, 0, 2, 3}, {0, 1, 1, 1, 0, 0}, {0, 1, 1, 1, 0, 1}, {0, 1, 1, 1, 0, 2}, {0, 1, 1, 1, 1, 0}, {0, 1, 1, 1, 1, 1}, {0, 1, 1, 1, 1, 2}, {0, 1, 1, 1, 2, 0}, {0, 1, 1, 1, 2, 1}, {0, 1, 1, 1, 2, 2}, {0, 1, 1, 1, 2, 3}, {0, 1, 1, 2, 0, 0}, {0, 1, 1, 2, 0, 1}, {0, 1, 1, 2, 0, 2}, {0, 1, 1, 2, 0, 3}, {0, 1, 1, 2, 1, 0}, {0, 1, 1, 2, 1, 1}, {0, 1, 1, 2, 1, 2}, {0, 1, 1, 2, 1, 3}, {0, 1, 1, 2, 2, 0}, {0, 1, 1, 2, 2, 1}, {0, 1, 1, 2, 2, 2}, {0, 1, 1, 2, 2, 3}, {0, 1, 1, 2, 3, 0}, {0, 1, 1, 2, 3, 1}, {0, 1, 1, 2, 3, 2}, {0, 1, 1, 2, 3, 3}, {0, 1, 1, 2, 3, 4}, {0, 1, 2, 0, 0, 0}, {0, 1, 2, 0, 0, 1}, {0, 1, 2, 0, 0, 2}, {0, 1, 2, 0, 0, 3}, {0, 1, 2, 0, 1, 0}, {0, 1, 2, 0, 1, 1}, {0, 1, 2, 0, 1, 2}, {0, 1, 2, 0, 1, 3}, {0, 1, 2, 0, 2, 0}, {0, 1, 2, 0, 2, 1}, {0, 1, 2, 0, 2, 2}, {0, 1, 2, 0, 2, 3}, {0, 1, 2, 0, 3, 0}, {0, 1, 2, 0, 3, 1}, {0, 1, 2, 0, 3, 2}, {0, 1, 2, 0, 3, 3}, {0, 1, 2, 0, 3, 4}, {0, 1, 2, 1, 0, 0}, {0, 1, 2, 1, 0, 1}, {0, 1, 2, 1, 0, 2}, {0, 1, 2, 1, 0, 3}, {0, 1, 2, 1, 1, 0}, {0, 1, 2, 1, 1, 1}, {0, 1, 2, 1, 1, 2}, {0, 1, 2, 1, 1, 3}, {0, 1, 2, 1, 2, 0}, {0, 1, 2, 1, 2, 1}, {0, 1, 2, 1, 2, 2}, {0, 1, 2, 1, 2, 3}, {0, 1, 2, 1, 3, 0}, {0, 1, 2, 1, 3, 1}, {0, 1, 2, 1, 3, 2}, {0, 1, 2, 1, 3, 3}, {0, 1, 2, 1, 3, 4}, {0, 1, 2, 2, 0, 0}, {0, 1, 2, 2, 0, 1}, {0, 1, 2, 2, 0, 2}, {0, 1, 2, 2, 0, 3}, {0, 1, 2, 2, 1, 0}, {0, 1, 2, 2, 1, 1}, {0, 1, 2, 2, 1, 2}, {0, 1, 2, 2, 1, 3}, {0, 1, 2, 2, 2, 0}, {0, 1, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2}, {0, 1, 2, 2, 2, 3}, {0, 1, 2, 2, 3, 0}, {0, 1, 2, 2, 3, 1}, {0, 1, 2, 2, 3, 2}, {0, 1, 2, 2, 3, 3}, {0, 1, 2, 2, 3, 4}, {0, 1, 2, 3, 0, 0}, {0, 1, 2, 3, 0, 1}, {0, 1, 2, 3, 0, 2}, {0, 1, 2, 3, 0, 3}, {0, 1, 2, 3, 0, 4}, {0, 1, 2, 3, 1, 0}, {0, 1, 2, 3, 1, 1}, {0, 1, 2, 3, 1, 2}, {0, 1, 2, 3, 1, 3}, {0, 1, 2, 3, 1, 4}, {0, 1, 2, 3, 2, 0}, {0, 1, 2, 3, 2, 1}, {0, 1, 2, 3, 2, 2}, {0, 1, 2, 3, 2, 3}, {0, 1, 2, 3, 2, 4}, {0, 1, 2, 3, 3, 0}, {0, 1, 2, 3, 3, 1}, {0, 1, 2, 3, 3, 2}, {0, 1, 2, 3, 3, 3}, {0, 1, 2, 3, 3, 4}, {0, 1, 2, 3, 4, 0}, {0, 1, 2, 3, 4, 1}, {0, 1, 2, 3, 4, 2}, {0, 1, 2, 3, 4, 3}, {0, 1, 2, 3, 4, 4}, {0, 1, 2, 3, 4, 5}};
    static final int JC69 = 0;
    static final int HKY = 55;
    static final int TN93 = 58;
    static final int TIM = 172;
    static final int NEW = 176;
    static final int NEW2 = 167;
    static final int GTR = 202;
    static final int TVM = 190;
    static final int XTRA = 176;
    static final int K81 = 164;

    public BModelSet(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.initModels();
    }

    private void initModels() {
        MODELS = this.generateAllModels();
        switch (this.modelSet) {
            case allreversible: {
                this.models = MODELS;
                break;
            }
            case transitionTransversionSplit: {
                this.models = MODELS;
                this.calcSubGroupCount(this.models);
                this.calcDag();
                this.setChildren(0, 55);
                this.models = this.filterModels();
                break;
            }
            case namedSimple: {
                this.models = MODELS;
                this.calcSubGroupCount(this.models);
                this.calcDag();
                this.setChildren(0, 55);
                this.setChildren(55, 58);
                this.setChildren(58, 202);
                this.models = this.filterModels();
                this.mergedModels = new List[this.models.length];
                this.splitModels = new List[this.models.length];
                for (int i = 0; i < 3; ++i) {
                    this.mergedModels[i + 1] = new ArrayList<Integer>();
                    this.splitModels[i] = new ArrayList<Integer>();
                    this.mergedModels[i + 1].add(i);
                    this.splitModels[i].add(i + 1);
                }
                this.splitModels[3] = new ArrayList<Integer>();
                this.mergedModels[0] = new ArrayList<Integer>();
                break;
            }
            case namedExtended: {
                this.models = MODELS;
                this.calcSubGroupCount(this.models);
                this.calcDag();
                this.setChildren(0, 55);
                this.setChildren(55, 58);
                this.splitModels[55].add(164);
                this.setChildren(58, 172);
                this.setChildren(164, 167);
                this.setChildren(172, 176);
                this.splitModels[172].add(176);
                this.setChildren(190, 202);
                this.setChildren(176, 202);
                this.models = this.filterModels();
            }
        }
    }

    protected int[][] generateAllModels() {
        return this.generateAllReversibleModels(new int[6]);
    }

    int[][] generateAllReversibleModels(int[] model) {
        ArrayList<int[]> modelset = new ArrayList<int[]>();
        while (model != null) {
            int[] nextmodel = (int[])model.clone();
            boolean[] done = new boolean[6];
            int groupcount = 0;
            int max = 0;
            for (int d : nextmodel) {
                max = Math.max(d + 1, max);
                if (done[d]) continue;
                done[d] = true;
                ++groupcount;
            }
            if (max == groupcount) {
                BModelSet.normaliseModel(nextmodel);
                modelset.add(nextmodel);
            }
            model = this.nextModel(model);
        }
        Collections.sort(modelset, new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                for (int i = 0; i < o1.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    if (o1[i] > o2[i]) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
        for (int i = modelset.size() - 1; i > 0; --i) {
            int[] model1 = (int[])modelset.get(i);
            int[] model2 = (int[])modelset.get(i - 1);
            boolean equals = true;
            for (int k = 0; k < model1.length; ++k) {
                if (model1[k] == model2[k]) continue;
                equals = false;
                break;
            }
            if (!equals) continue;
            modelset.remove(i);
        }
        return (int[][])modelset.toArray((T[])new int[0][]);
    }

    private int[] nextModel(int[] model) {
        int pos;
        int[] nextmodel = (int[])model.clone();
        for (pos = 5; pos >= 0 && nextmodel[pos] == pos; --pos) {
            nextmodel[pos] = 0;
        }
        if (pos == -1) {
            return null;
        }
        int n = pos;
        nextmodel[n] = nextmodel[n] + 1;
        return nextmodel;
    }

    public static void normaliseModel(int[] newmodel) {
        int i;
        int[] shouldbe = new int[newmodel.length];
        Arrays.fill(shouldbe, -1);
        int k = 0;
        for (i = 0; i < newmodel.length; ++i) {
            if (shouldbe[newmodel[i]] != -1) continue;
            shouldbe[newmodel[i]] = k++;
        }
        for (i = 0; i < newmodel.length; ++i) {
            newmodel[i] = shouldbe[newmodel[i]];
        }
    }

    private int[][] filterModels() {
        HashSet<Integer> filtered = new HashSet<Integer>();
        filtered.add(0);
        HashSet<Integer> candidates = new HashSet<Integer>();
        candidates.add(0);
        boolean[] done = new boolean[this.models.length];
        while (candidates.size() > 0) {
            int i = (Integer)candidates.toArray()[0];
            if (!done[i]) {
                for (int child : this.splitModels[i]) {
                    candidates.add(child);
                    filtered.add(child);
                }
                done[i] = true;
            }
            candidates.remove(i);
        }
        int[][] filteredModels = new int[filtered.size()][];
        ArrayList<Integer> f = new ArrayList<Integer>();
        f.addAll(filtered);
        Collections.sort(f);
        int k = 0;
        Iterator iterator = f.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            filteredModels[k++] = this.models[i];
        }
        this.splitModels = null;
        this.mergedModels = null;
        return filteredModels;
    }

    private void calcDag() {
        int i;
        this.mergedModels = new List[this.models.length];
        this.splitModels = new List[this.models.length];
        for (i = 0; i < this.models.length; ++i) {
            this.mergedModels[i] = new ArrayList<Integer>();
            this.splitModels[i] = new ArrayList<Integer>();
        }
        for (i = 0; i < this.models.length; ++i) {
            for (int j = 0; j < this.models.length; ++j) {
                if (!this.isSplit(j, i)) continue;
                this.mergedModels[i].add(j);
                boolean todo = this.isSplit(i, j);
                this.splitModels[j].add(i);
            }
        }
    }

    public boolean isSplit(int m1, int m2) {
        if (this.getGroupCount(m1) + 1 != this.getGroupCount(m2)) {
            return false;
        }
        int[] model1 = this.models[m1];
        int[] model2 = this.models[m2];
        int[] map = new int[model1.length];
        Arrays.fill(map, -1);
        int[] revmap = new int[model1.length];
        Arrays.fill(revmap, -1);
        int k1 = -1;
        int k2 = -1;
        for (int i = 0; i < model1.length; ++i) {
            if (map[model1[i]] == model2[i]) continue;
            if (map[model1[i]] < 0 && revmap[model2[i]] < 0) {
                map[model1[i]] = model2[i];
                revmap[model2[i]] = model1[i];
                continue;
            }
            if (k2 < 0) {
                k1 = model1[i];
                k2 = model2[i];
                continue;
            }
            if (model1[i] == k1 && model2[i] == k2) continue;
            return false;
        }
        return k2 >= 0;
    }

    private void calcSubGroupCount(int[][] models) {
        int i;
        this.groupCount = new int[models.length];
        this.subgroupCount = new int[models.length][6];
        for (i = 0; i < models.length; ++i) {
            for (int j = 0; j < 6; ++j) {
                int m = models[i][j];
                this.groupCount[i] = Math.max(this.groupCount[i], m + 1);
                int[] nArray = this.subgroupCount[i];
                int n = m;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.modelID = new int[models.length];
        for (i = 0; i < models.length; ++i) {
            this.modelID[i] = this.calcModelID(models[i]);
        }
    }

    private int calcModelID(int[] model) {
        int modelID = 0;
        int k = 1;
        for (int j = model.length - 1; j >= 0; --j) {
            modelID += model[j] * k;
            k *= 10;
        }
        return modelID;
    }

    private void setChildren(int parent, int child) {
        this.splitModels[parent].clear();
        this.splitModels[parent].add(child);
    }

    @MethodInfo(narrativeName="number of models", verbClause="in", description="the number of models in this model set.")
    public Integer size() {
        return this.models.length;
    }

    @MethodInfo(narrativeName="the name of this model set", verbClause="in", description="the number of models in this model set.")
    public String getName() {
        return this.modelSet.name();
    }

    @MethodInfo(narrativeName="name of the model", description="the name of the given model indicator.")
    public String getModelName(Integer modelIndicator) {
        int[] model = this.getModel(modelIndicator);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < model.length; ++i) {
            builder.append(model[i]);
        }
        return builder.toString();
    }

    public int[] getModel(int i) {
        return this.models[i];
    }

    public int getGroupCount(int i) {
        return this.groupCount[i];
    }

    public int[] getSubGroupCount(int i) {
        return this.subgroupCount[i];
    }

    public int getMaxGroupCount() {
        return 6;
    }

    public int getModelNumber(int[] model) {
        int _modelID = this.calcModelID(model);
        int i = Arrays.binarySearch(this.modelID, _modelID);
        return i;
    }

    public static enum ModelSet {
        allreversible,
        transitionTransversionSplit,
        namedSimple,
        namedExtended;

    }
}

