/*
 * Decompiled with CFR 0.152.
 */
package lphy.bmodeltest;

import java.util.Map;
import lphy.bmodeltest.BModelSet;
import lphy.evolution.substitutionmodel.RateMatrix;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleArray2DValue;

@Citation(value="Bouckaert, R., Drummond, A. bModelTest: Bayesian phylogenetic site model averaging and model comparison. BMC Evol Biol 17, 42 (2017). https://doi.org/10.1186/s12862-017-0890-6", title="bModelTest: Bayesian phylogenetic site model averaging and model comparison", authors={"Bouckaert", "Drummond"}, year=2017, DOI="https://doi.org/10.1186/s12862-017-0890-6")
public class NucleotideModel
extends RateMatrix {
    public static final String ratesParamName = "rates";
    public static final String freqParamName = "freq";
    public static final String modelParamName = "modelIndicator";
    public static final String modelSetParamName = "modelSet";

    public NucleotideModel(@ParameterInfo(name="modelSet", narrativeName="model set", description="The set of models to choose from. Valid value are: allreversible, transitionTransversionSplit, namedSimple, namedExtended.") Value<BModelSet> modelSet, @ParameterInfo(name="modelIndicator", narrativeName="model index", description="the index of the model to be employed") Value<Integer> modelIndex, @ParameterInfo(name="rates", narrativeName="relative rates", description="the relative rates of the GTR process.") Value<Double[]> rates, @ParameterInfo(name="freq", narrativeName="base frequencies", description="the base frequencies.") Value<Double[]> freq, @ParameterInfo(name="meanRate", narrativeName="substitution rate", description="the rate of substitution.", optional=true) Value<Number> meanRate) {
        super(meanRate);
        if (rates.value().length != 6) {
            throw new IllegalArgumentException("Rates must have 6 dimensions.");
        }
        this.setParam(ratesParamName, (Value)rates);
        this.setParam(freqParamName, (Value)freq);
        this.setParam(modelParamName, (Value)modelIndex);
        this.setParam(modelSetParamName, (Value)modelSet);
    }

    @Override
    @GeneratorInfo(name="nucleotideModel", verbClause="is", narrativeName="bModelTest rate matrix", description="The instantaneous rate matrix. Takes relative rates and base frequencies and produces an GTR rate matrix.")
    public Value<Double[][]> apply() {
        Map<String, Value> params = this.getParams();
        Value<Double[]> rates = this.getRates();
        Value freq = params.get(freqParamName);
        Value modelIndex = params.get(modelParamName);
        Value modelSet = params.get(modelSetParamName);
        return new DoubleArray2DValue(this.bModelTest((BModelSet)modelSet.value(), (Integer)modelIndex.value(), rates.value(), (Double[])freq.value()), (DeterministicFunction)this);
    }

    private Double[][] bModelTest(BModelSet modelSet, int modelIndex, Double[] rawRates, Double[] freqs) {
        int i;
        int numStates = 4;
        Double[][] Q = new Double[numStates][numStates];
        int[] model = modelSet.getModel(modelIndex);
        double[] relativeRates = new double[rawRates.length];
        for (int i2 = 0; i2 < relativeRates.length; ++i2) {
            relativeRates[i2] = rawRates[model[i2]];
        }
        int upper = 0;
        for (i = 0; i < numStates; ++i) {
            for (int j = i + 1; j < numStates; ++j) {
                Q[i][j] = relativeRates[upper] * freqs[j];
                Q[j][i] = relativeRates[upper] * freqs[i];
                ++upper;
            }
        }
        for (i = 0; i < numStates; ++i) {
            double totalRate = 0.0;
            for (int j = 0; j < numStates; ++j) {
                if (j == i) continue;
                totalRate += Q[i][j].doubleValue();
            }
            Q[i][i] = -totalRate;
        }
        this.normalize(freqs, Q, this.totalRateDefault1());
        return Q;
    }

    public Value<Double[]> getRates() {
        return this.getParams().get(ratesParamName);
    }

    public Value<Double[]> getFreq() {
        return this.getParams().get(freqParamName);
    }
}

