/*
 * Decompiled with CFR 0.152.
 */
package lphy.bmodeltest;

import java.util.Map;
import lphy.evolution.sitemodel.SiteModel;
import lphy.graphicalModel.Citation;
import lphy.graphicalModel.DeterministicFunction;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;

@Citation(value="Bouckaert, R., Drummond, A. bModelTest: Bayesian phylogenetic site model averaging and model comparison. BMC Evol Biol 17, 42 (2017). https://doi.org/10.1186/s12862-017-0890-6", title="bModelTest: Bayesian phylogenetic site model averaging and model comparison", authors={"Bouckaert", "Drummond"}, year=2017, DOI="https://doi.org/10.1186/s12862-017-0890-6")
public class bSiteModelFunction
extends DeterministicFunction<SiteModel> {
    public static final String useSiteRatesParamName = "useSiteRates";
    public static final String useProportionInvariableParamName = "usePInv";
    public static final String proportionInvariableParamName = "pInv";

    public bSiteModelFunction(@ParameterInfo(name="Q", narrativeName="instantaneous rate matrix", description="the instantaneous rate matrix.") Value<Double[][]> Q, @ParameterInfo(name="siteRates", narrativeName="site rates", description="raw site rates.") Value<Double[]> siteRates, @ParameterInfo(name="pInv", narrativeName="proportion of invariable sites", description="the proportion of invariable sites parameter") Value<Number> proportionInvariable, @ParameterInfo(name="useSiteRates", narrativeName="site rate heterogeneity indicator", description="true if the site rates have heterogeneity.") Value<Boolean> useSiteRates, @ParameterInfo(name="usePInv", narrativeName="proportion invariable indicator", description="true if the proportion invariable used.") Value<Boolean> useProportionInvariable) {
        this.setParam("Q", (Value)Q);
        this.setParam("siteRates", (Value)siteRates);
        this.setParam(proportionInvariableParamName, (Value)proportionInvariable);
        this.setParam(useSiteRatesParamName, (Value)useSiteRates);
        this.setParam(useProportionInvariableParamName, (Value)useProportionInvariable);
    }

    @Override
    @GeneratorInfo(name="bSiteModel", narrativeName="bModelTest site model", verbClause="is", description="Returns the site model for the given parameters.")
    public Value<SiteModel> apply() {
        Map<String, Value> params = this.getParams();
        Value Q = params.get("Q");
        Value siteRatesParam = params.get("siteRates");
        Value proportionInvariableParam = params.get(proportionInvariableParamName);
        Value useSiteRates = params.get(useSiteRatesParamName);
        Value useProportionInvariable = params.get(useProportionInvariableParamName);
        Double[] siteRates = null;
        Double proportionInvariable = 0.0;
        if (((Boolean)useSiteRates.value()).booleanValue()) {
            siteRates = (Double[])siteRatesParam.value();
        }
        if (((Boolean)useProportionInvariable.value()).booleanValue()) {
            proportionInvariable = ValueUtils.doubleValue(proportionInvariableParam);
        }
        SiteModel siteModel = new SiteModel((Double[][])Q.value(), siteRates, proportionInvariable);
        return new Value<SiteModel>(null, siteModel, this);
    }
}

