/*
 * Decompiled with CFR 0.152.
 */
package lphy.bmodeltest;

import java.util.Arrays;
import java.util.SortedMap;
import java.util.TreeMap;
import lphy.core.distributions.DiscretizedGamma;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class bSiteRates
implements GenerativeDistribution<Double[]> {
    public static final String ncatParamName = "ncat";
    public static final String useShapeParamName = "useShape";
    public static final String useProportionInvariableParamName = "useProportionInvariable";
    public static final String proportionInvariableParamName = "proportionInvariable";
    RandomGenerator random = Utils.getRandom();
    Value<Number> shape;
    Value<Integer> ncat;
    Value<Integer> L;
    Value<Number> proportionInvariable;
    Value<Boolean> useShape;
    Value<Boolean> useProportionInvariable;

    public bSiteRates(@ParameterInfo(name="shape", narrativeName="Gamma shape parameter", description="the shape parameter of the discretized Gamma distribution.") Value<Number> shape, @ParameterInfo(name="ncat", narrativeName="number of categories", description="the number of categories of the discretized Gamma distribution.") Value<Integer> ncat, @ParameterInfo(name="L", narrativeName="number of sites", description="the number of sites to simulate.") Value<Integer> L, @ParameterInfo(name="proportionInvariable", narrativeName="proportion of invariable sites", description="the proportion of invariable sites parameter") Value<Number> proportionInvariable, @ParameterInfo(name="useShape", narrativeName="shape parameter indicator", description="true if the non-zero site rates follow a discretized Gamma distribution.") Value<Boolean> useShape, @ParameterInfo(name="useProportionInvariable", narrativeName="use proportional indicator", description="true if there is a proportion of invariable sites.") Value<Boolean> useProportionInvariable) {
        this.shape = shape;
        this.ncat = ncat;
        this.L = L;
        this.proportionInvariable = proportionInvariable;
        this.useShape = useShape;
        this.useProportionInvariable = useProportionInvariable;
    }

    @Override
    @GeneratorInfo(name="bSiteRates", verbClause="is", description="the site rates for the given bModelTest parameters.")
    public RandomVariable<Double[]> sample() {
        Object[] siteRates = new Double[this.L.value().intValue()];
        Double pInv = 0.0;
        boolean hasShape = this.useShape.value();
        if (hasShape) {
            DiscretizedGamma discretizedGamma = new DiscretizedGamma(this.shape, this.ncat);
            for (int i = 0; i < siteRates.length; ++i) {
                siteRates[i] = (Double)discretizedGamma.sample().value();
            }
        } else {
            Arrays.fill(siteRates, (Object)1.0);
        }
        if (this.useProportionInvariable.value().booleanValue()) {
            pInv = ValueUtils.doubleValue(this.proportionInvariable);
        }
        for (int i = 0; i < siteRates.length; ++i) {
            if (!(pInv > 0.0) || !(this.random.nextDouble() < pInv)) continue;
            siteRates[i] = 0.0;
        }
        return new RandomVariable<Double[]>(null, (Double[])siteRates, this);
    }

    public SortedMap<String, Value> getParams() {
        TreeMap<String, Value> map = new TreeMap<String, Value>();
        map.put("shape", this.shape);
        map.put(ncatParamName, this.ncat);
        map.put("L", this.L);
        map.put(proportionInvariableParamName, this.proportionInvariable);
        map.put(useShapeParamName, this.useShape);
        map.put(useProportionInvariableParamName, this.useProportionInvariable);
        return map;
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "shape": {
                this.shape = value;
                break;
            }
            case "ncat": {
                this.ncat = value;
                break;
            }
            case "L": {
                this.L = value;
                break;
            }
            case "proportionInvariable": {
                this.proportionInvariable = value;
                break;
            }
            case "useShape": {
                this.useShape = value;
                break;
            }
            case "useProportionInvariable": {
                this.useProportionInvariable = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }
}

