/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class CTMC
implements GenerativeDistribution<Integer> {
    Value<Integer> X;
    Value<Double> t;
    Value<double[][]> Q;
    Random random;
    public static final String XParamName = "X";
    public static final String tParamName = "t";
    public static final String QParamName = "Q";

    public CTMC(@ParameterInfo(name="X", description="the starting state.") Value<Integer> X, @ParameterInfo(name="t", description="the time.") Value<Double> t, @ParameterInfo(name="Q", description="the instantaneous rate matrix.") Value<double[][]> Q, Random random) {
        this.X = X;
        this.t = t;
        this.Q = Q;
        this.random = random;
    }

    @Override
    public RandomVariable<Integer> sample() {
        Array2DRowRealMatrix q = new Array2DRowRealMatrix(this.Q.value());
        q.scalarMultiply(this.t.value().doubleValue());
        EigenDecomposition decomposition = new EigenDecomposition((RealMatrix)q);
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(CTMC.tParamName, CTMC.this.t);
                this.put(CTMC.QParamName, CTMC.this.Q);
                this.put(CTMC.XParamName, CTMC.this.X);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "t": {
                this.t = value;
                break;
            }
            case "Q": {
                this.Q = value;
                break;
            }
            case "X": {
                this.X = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }
}

