/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lphy.graphicalModel.Command;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.DoubleValue;
import lphy.graphicalModel.types.IntegerValue;
import lphy.parser.SimulatorParsingException;

public interface LPhyParser
extends GraphicalModel {
    public String getName();

    default public List<Value<?>> getNamedValuesByType(Class<?> type) {
        List<Value<?>> valuesByType = this.getDataDictionary().values().stream().filter(v -> type.isAssignableFrom(v.value().getClass()) && !v.isAnonymous()).collect(Collectors.toList());
        valuesByType.addAll(this.getModelDictionary().values().stream().filter(v -> type.isAssignableFrom(v.value().getClass()) && !v.isAnonymous()).collect(Collectors.toList()));
        return valuesByType;
    }

    default public List<String> getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.addAll(this.getGeneratorClasses().keySet());
        return keywords;
    }

    default public void parse(String code) {
        this.parse(code, GraphicalModel.Context.model);
    }

    public void parse(String var1, GraphicalModel.Context var2) throws SimulatorParsingException;

    public Map<String, Set<Class<?>>> getGeneratorClasses();

    public List<String> getLines();

    public void clear();

    default public void source(File sourceFile) throws IOException {
        FileReader reader = new FileReader(sourceFile);
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.source(bufferedReader);
        reader.close();
    }

    default public void source(BufferedReader bufferedReader) throws IOException {
        StringBuilder builder = new StringBuilder();
        String line = bufferedReader.readLine();
        while (line != null) {
            builder.append(line);
            builder.append("\n");
            line = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.parse(builder.toString());
    }

    default public String getUniqueId(Value value) {
        Object uniqueId = value.getCanonicalId();
        if (uniqueId == null) {
            uniqueId = value.getUniqueId();
        }
        if (this.isClamped(value.getId()) && this.isNamedDataValue(value)) {
            uniqueId = "'" + (String)uniqueId + "'";
        }
        return uniqueId;
    }

    public static class Utils {
        private static Map<String, Value<?>> parseArguments(String argumentString, LPhyParser parser) {
            String[] argumentStrings = Utils.splitArgumentString(argumentString);
            TreeMap arguments = new TreeMap();
            int argumentCount = 0;
            for (int i = 0; i < argumentStrings.length; ++i) {
                Object argumentPair = argumentStrings[i];
                System.out.println("arg" + i + ": " + (String)argumentPair);
                if (((String)argumentPair).indexOf(61) < 0) {
                    argumentPair = argumentCount + "=" + (String)argumentPair;
                }
                int pos = ((String)argumentPair).indexOf(61);
                String key = ((String)argumentPair).substring(0, pos).trim();
                String valueString = ((String)argumentPair).substring(pos + 1).trim();
                Value val = Utils.parseValueExpression(valueString, parser, GraphicalModel.Context.model);
                arguments.put(key, val);
                ++argumentCount;
            }
            return arguments;
        }

        private static Value parseValueExpression(String valueString, GraphicalModel model, GraphicalModel.Context context) {
            Value val = model.getValue(valueString, context);
            if (val != null) {
                return val;
            }
            if (Command.CommandUtils.isLiteral(valueString)) {
                return Utils.parseLiteralValue(null, valueString);
            }
            throw new RuntimeException("Failed to parse value expression " + valueString);
        }

        private static Value parseLiteralValue(String id, String valueString) {
            if (valueString.startsWith("\"") && valueString.endsWith("\"")) {
                return new Value<String>(id, valueString.substring(1, valueString.length() - 1));
            }
            try {
                Integer intVal = Integer.parseInt(valueString);
                return new IntegerValue(id, intVal);
            }
            catch (NumberFormatException intVal) {
                try {
                    Double val = Double.parseDouble(valueString);
                    return new DoubleValue(id, val);
                }
                catch (NumberFormatException val) {
                    try {
                        Boolean booleanValue = Boolean.parseBoolean(valueString);
                        return new Value<Boolean>(id, booleanValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RuntimeException("Parsing fixed parameter " + id + " with value " + valueString);
                    }
                }
            }
        }

        private static String[] splitArgumentString(String argumentString) {
            if (argumentString.length() == 0) {
                return new String[0];
            }
            String argumentSplitterPattern = ",(?=(([^']*'){2})*[^']*$)(?=(([^\"]*\"){2})*[^\"]*$)(?![^()]*\\))(?![^\\[]*\\])";
            return argumentString.split(argumentSplitterPattern);
        }
    }
}

