/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import lphy.core.GraphicalLPhyParser;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.GraphicalModel;
import lphy.graphicalModel.RandomValueLogger;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.util.LoggerUtils;

public class Sampler {
    GraphicalLPhyParser parser;

    public Sampler(GraphicalLPhyParser parser) {
        this.parser = parser;
    }

    public void sample(int reps, List<RandomValueLogger> loggers) {
        for (int i = 0; i < reps; ++i) {
            TreeSet<String> sampled = new TreeSet<String>();
            List<Value<?>> sinks = this.parser.getModelSinks();
            for (RandomVariable<?> randomVariable : this.parser.getAllVariablesFromSinks()) {
                this.parser.getModelDictionary().remove(randomVariable.getId());
            }
            for (Value value : sinks) {
                if (!value.isRandom()) continue;
                if (value.getGenerator() == null) {
                    throw new RuntimeException();
                }
                Value randomValue = this.sampleAll(value, value.getGenerator(), sampled);
                randomValue.setId(value.getId());
                this.addValueToModelDictionary(randomValue);
            }
            if (loggers == null) continue;
            List<Value<?>> values = GraphicalModel.Utils.getAllValuesFromSinks(this.parser);
            for (RandomValueLogger logger : loggers) {
                logger.log(i, values);
            }
        }
        if (loggers != null) {
            for (RandomValueLogger logger : loggers) {
                logger.close();
            }
        }
        this.parser.notifyListeners();
    }

    private Value sampleAll(Value oldValue, Generator generator, Set<String> sampled) {
        for (Map.Entry<String, Value> e : this.getNewlySampledParams(generator, sampled).entrySet()) {
            generator.setInput(e.getKey(), e.getValue());
            if (e.getValue().isAnonymous()) continue;
            sampled.add(e.getValue().getId());
        }
        return generator.generate();
    }

    private Map<String, Value> getNewlySampledParams(Generator generator, Set<String> sampled) {
        LoggerUtils.log.fine("getNewlySampledParams(" + generator.getName() + ")");
        Map<String, Value> params = generator.getParams();
        TreeMap<String, Value> newlySampledParams = new TreeMap<String, Value>();
        for (Map.Entry<String, Value> e : params.entrySet()) {
            Value val = e.getValue();
            if (!val.isRandom()) continue;
            if (val.isAnonymous() || !sampled.contains(val.getId())) {
                Value nv = this.sampleAll(val, val.getGenerator(), sampled);
                nv.setId(val.getId());
                newlySampledParams.put(e.getKey(), nv);
                this.addValueToModelDictionary(nv);
                if (val.isAnonymous()) continue;
                sampled.add(val.getId());
                continue;
            }
            String id = e.getValue().getId();
            newlySampledParams.put(e.getKey(), this.parser.getModelDictionary().get(id));
        }
        return newlySampledParams;
    }

    private void addValueToModelDictionary(Value value) {
        if (!value.isAnonymous()) {
            String id = value.getId();
            this.parser.getModelDictionary().put(id, value);
        }
    }
}

