/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.io.BufferedReader;
import java.io.IOException;
import lphy.graphicalModel.GraphicalModel;

public class Script {
    public String dataLines;
    public String modelLines;

    public Script(String dataLines, String modelLines) {
        this.dataLines = dataLines;
        this.modelLines = modelLines;
    }

    public static Script loadLPhyScript(BufferedReader reader) throws IOException {
        StringBuilder dataLines = new StringBuilder();
        StringBuilder modelLines = new StringBuilder();
        boolean level = false;
        String line = reader.readLine();
        GraphicalModel.Context context = GraphicalModel.Context.model;
        while (line != null) {
            boolean skip = false;
            if (line.matches("[ \\t]*data[ \\t]*\\{[ \\t]*")) {
                context = GraphicalModel.Context.data;
                skip = true;
            } else if (line.matches("[ \\t]*model[ \\t]*\\{[ \\t]*")) {
                context = GraphicalModel.Context.model;
                skip = true;
            } else if (line.matches("[ \\t]*}[ \\t]*")) {
                skip = true;
            }
            if (!skip) {
                switch (context) {
                    case data: {
                        dataLines.append(line);
                        dataLines.append("\n");
                        break;
                    }
                    case model: {
                        modelLines.append(line);
                        modelLines.append("\n");
                    }
                }
            }
            line = reader.readLine();
        }
        reader.close();
        return new Script(dataLines.toString(), modelLines.toString());
    }
}

