/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lphy.evolution.tree.TimeTree;
import lphy.graphicalModel.RandomValueLogger;
import lphy.graphicalModel.Value;
import lphy.nexus.NexusWriter;
import lphy.util.Symbols;

public class TreeFileLogger
implements RandomValueLogger {
    String name;
    Map<String, List<TimeTree>> trees;

    public TreeFileLogger(String name) {
        this.name = name;
    }

    @Override
    public void log(int rep, List<Value<?>> values) {
        List<Value<TimeTree>> treeVariables = this.getTreeValues(values);
        if (rep == 0) {
            this.trees = new TreeMap<String, List<TimeTree>>();
            for (Value<TimeTree> tv : treeVariables) {
                this.trees.put(tv.getId(), new ArrayList());
            }
        }
        for (Value<TimeTree> v : treeVariables) {
            this.trees.get(v.getId()).add(v.value());
        }
    }

    @Override
    public void close() {
        this.trees.forEach((key, treeList) -> {
            try {
                NexusWriter.write(null, treeList, new PrintStream(this.name + "_" + Symbols.getCanonical(key) + ".trees"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private List<Value<TimeTree>> getTreeValues(List<Value<?>> variables) {
        ArrayList<Value<TimeTree>> trees = new ArrayList<Value<TimeTree>>();
        for (Value<?> v : variables) {
            if (v.value() instanceof TimeTree) {
                trees.add(v);
                continue;
            }
            if (!(v.value() instanceof TimeTree[])) continue;
            TimeTree[] value = (TimeTree[])v.value();
            for (int i = 0; i < value.length; ++i) {
                TimeTree t = value[i];
                trees.add(new Value<TimeTree>(v.getId() + "_" + i, t));
            }
        }
        trees.sort(Comparator.comparing(Value::getId));
        return trees;
    }
}

