/*
 * Decompiled with CFR 0.152.
 */
package lphy.core;

import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lphy.graphicalModel.Loggable;
import lphy.graphicalModel.RandomValueLogger;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.util.Symbols;

public class VarFileLogger
implements RandomValueLogger {
    public static Map<Class, Loggable> loggableMap = new HashMap<Class, Loggable>();
    String name;
    List<String> lines;
    boolean logVariables;
    boolean logStatistics;

    public VarFileLogger(String name, boolean logStatistics, boolean logVariables) {
        this.name = name;
        this.logStatistics = logStatistics;
        this.logVariables = logVariables;
    }

    @Override
    public void log(int rep, List<Value<?>> randomValues) {
        Loggable loggable;
        StringBuilder builder = new StringBuilder();
        if (rep == 0) {
            this.lines = new ArrayList<String>();
            builder.append("sample");
            for (Value<?> randomValue : randomValues) {
                if (!this.isLogged(randomValue) || (loggable = loggableMap.get(randomValue.value().getClass())) == null) continue;
                for (String title : loggable.getLogTitles(randomValue)) {
                    builder.append("\t");
                    builder.append(title);
                }
            }
            builder.append("\n");
        }
        builder.append(rep);
        for (Value<?> randomValue : randomValues) {
            if (!this.isLogged(randomValue) || (loggable = loggableMap.get(randomValue.value().getClass())) == null) continue;
            for (Object logValue : loggable.getLogValues(randomValue)) {
                builder.append("\t");
                builder.append(logValue);
            }
        }
        builder.append("\n");
        this.lines.add(builder.toString());
    }

    @Override
    public void close() {
        try {
            FileWriter writer = new FileWriter(this.name + ".log");
            for (String line : this.lines) {
                writer.write(line);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isLogged(Value randomValue) {
        return randomValue instanceof RandomVariable && this.logVariables || !(randomValue instanceof RandomVariable) && randomValue.isRandom() && this.logStatistics && !randomValue.isAnonymous();
    }

    static {
        loggableMap.put(Integer.class, new Loggable<Integer>(){

            @Override
            public String[] getLogTitles(Value<Integer> value) {
                return new String[]{Symbols.getCanonical(value.getId())};
            }

            public Integer[] getLogValues(Value<Integer> value) {
                return new Integer[]{value.value()};
            }
        });
        loggableMap.put(Boolean.class, new Loggable<Boolean>(){

            @Override
            public String[] getLogTitles(Value<Boolean> value) {
                return new String[]{Symbols.getCanonical(value.getId())};
            }

            public Boolean[] getLogValues(Value<Boolean> value) {
                return new Boolean[]{value.value()};
            }
        });
        loggableMap.put(Double.class, new Loggable<Double>(){

            @Override
            public String[] getLogTitles(Value<Double> value) {
                return new String[]{Symbols.getCanonical(value.getId())};
            }

            public Double[] getLogValues(Value<Double> value) {
                return new Double[]{value.value()};
            }
        });
        loggableMap.put(Double[].class, new Loggable<Double[]>(){

            @Override
            public String[] getLogTitles(Value<Double[]> value) {
                String[] names = new String[value.value().length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = Symbols.getCanonical(value.getId()) + "_" + i;
                }
                return names;
            }

            public Double[] getLogValues(Value<Double[]> value) {
                return value.value();
            }
        });
        loggableMap.put(Integer[].class, new Loggable<Integer[]>(){

            @Override
            public String[] getLogTitles(Value<Integer[]> value) {
                String[] names = new String[value.value().length];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = Symbols.getCanonical(value.getId()) + "_" + i;
                }
                return names;
            }

            public Integer[] getLogValues(Value<Integer[]> value) {
                return value.value();
            }
        });
        loggableMap.put(Double[][].class, new Loggable<Double[][]>(){

            @Override
            public String[] getLogTitles(Value<Double[][]> value) {
                ArrayList<CallSite> names = new ArrayList<CallSite>();
                Double[][] tmpArr = value.value();
                for (int i = 0; i < tmpArr.length; ++i) {
                    for (int j = 0; j < tmpArr[i].length; ++j) {
                        names.add((CallSite)((Object)(Symbols.getCanonical(value.getId()) + "_" + i + "_" + j)));
                    }
                }
                return (String[])names.toArray(String[]::new);
            }

            public Double[] getLogValues(Value<Double[][]> value) {
                Double[][] tmpArr;
                ArrayList<Double> vals = new ArrayList<Double>();
                for (Double[] doubles : tmpArr = value.value()) {
                    vals.addAll(Arrays.asList(doubles));
                }
                return (Double[])vals.toArray(Double[]::new);
            }
        });
        loggableMap.put(Integer[][].class, new Loggable<Integer[][]>(){

            @Override
            public String[] getLogTitles(Value<Integer[][]> value) {
                ArrayList<CallSite> names = new ArrayList<CallSite>();
                Integer[][] tmpArr = value.value();
                for (int i = 0; i < tmpArr.length; ++i) {
                    for (int j = 0; j < tmpArr[i].length; ++j) {
                        names.add((CallSite)((Object)(Symbols.getCanonical(value.getId()) + "_" + i + "_" + j)));
                    }
                }
                return (String[])names.toArray(String[]::new);
            }

            public Integer[] getLogValues(Value<Integer[][]> value) {
                Integer[][] tmpArr;
                ArrayList<Integer> vals = new ArrayList<Integer>();
                for (Integer[] doubles : tmpArr = value.value()) {
                    vals.addAll(Arrays.asList(doubles));
                }
                return (Integer[])vals.toArray(Integer[]::new);
            }
        });
    }
}

