/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Collections;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.random.RandomGenerator;

public class Bernoulli
implements GenerativeDistribution<Boolean> {
    private Value<Number> p;
    private RandomGenerator random;

    public Bernoulli(@ParameterInfo(name="p", description="the probability of success.") Value<Number> p) {
        this.p = p;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Bernoulli", description="The coin toss distribution. With true (heads) having probability p.")
    public RandomVariable<Boolean> sample() {
        boolean success = this.random.nextDouble() < ValueUtils.doubleValue(this.p);
        return new RandomVariable<Boolean>("x", Boolean.valueOf(success), this);
    }

    @Override
    public double density(Boolean success) {
        return success != false ? ValueUtils.doubleValue(this.p) : 1.0 - ValueUtils.doubleValue(this.p);
    }

    @Override
    public Map<String, Value> getParams() {
        return Collections.singletonMap("p", this.p);
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (!paramName.equals("p")) {
            throw new RuntimeException("Only valid parameter name is p");
        }
        this.p = value;
    }

    public void setP(Double p) {
        this.p.setValue(p);
    }

    public String toString() {
        return this.getName();
    }
}

