/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.RandomBooleanArray;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.types.IntegerValue;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class BernoulliMulti
implements GenerativeDistribution<Boolean[]> {
    private Value<Double> p;
    private Value<Integer> n;
    private Value<Integer> minSuccesses;
    private RandomGenerator random;
    public final String minSuccessesParamName = "minSuccesses";
    private final String repParamName = "replicates";
    private static final int MAX_TRIES = 1000;

    public BernoulliMulti(@ParameterInfo(name="p", description="the probability of success.") Value<Double> p, @ParameterInfo(name="replicates", description="the number of bernoulli trials.") Value<Integer> n, @ParameterInfo(name="minSuccesses", description="Optional condition: the minimum number of ones in the boolean array.", optional=true) Value<Integer> minSuccesses) {
        this.p = p;
        this.n = n;
        this.minSuccesses = minSuccesses;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Bernoulli", description="The Bernoulli process for n iid trials. The success (true) probability is p. Produces a boolean n-tuple.")
    public RandomVariable<Boolean[]> sample() {
        Boolean[] b = this.bernoulli(this.p.value(), this.n.value());
        if (this.minSuccesses != null) {
            BinomialDistribution binomialDistribution = new BinomialDistribution(this.n.value().intValue(), this.p.value().doubleValue());
            double[] p = new double[this.n.value() - this.minSuccesses.value()];
            double probSum = 0.0;
            int k = this.minSuccesses.value();
            for (int i = 0; i < p.length; ++i) {
                p[i] = binomialDistribution.probability(i + k);
                probSum += p[i];
            }
            if (probSum > 0.0) {
                double U = this.random.nextDouble() * probSum;
                probSum = 0.0;
                int index = 0;
                for (int i = 0; i < p.length; ++i) {
                    if (!((probSum += p[i]) > U)) continue;
                    index = i;
                    break;
                }
                RandomBooleanArray randomBooleanArray = new RandomBooleanArray(this.n, new IntegerValue(index + k, null));
                b = (Boolean[])randomBooleanArray.sample().value();
            } else {
                throw new RuntimeException("minSuccesses is too high and there is no probability above it due to numerical precision.");
            }
        }
        return new RandomVariable<Boolean[]>(null, b, this);
    }

    private int hammingWeight(Boolean[] b) {
        int sum = 0;
        for (Boolean i : b) {
            if (!i.booleanValue()) continue;
            ++sum;
        }
        return sum;
    }

    private Boolean[] bernoulli(double p, int n) {
        Boolean[] successes = new Boolean[n];
        for (int i = 0; i < successes.length; ++i) {
            successes[i] = this.random.nextDouble() < p;
        }
        return successes;
    }

    @Override
    public double logDensity(Boolean[] successes) {
        double logP = 0.0;
        double lnp = Math.log(this.p.value());
        double ln1mp = Math.log(1.0 - this.p.value());
        for (int i = 0; i < successes.length; ++i) {
            logP += successes[i] != false ? lnp : ln1mp;
        }
        return logP;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("p", BernoulliMulti.this.p);
                this.put("replicates", BernoulliMulti.this.n);
                if (BernoulliMulti.this.minSuccesses != null) {
                    this.put("minSuccesses", BernoulliMulti.this.minSuccesses);
                }
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "p": {
                this.p = value;
                break;
            }
            case "replicates": {
                this.n = value;
                break;
            }
            case "minSuccesses": {
                this.minSuccesses = value;
                break;
            }
            default: {
                throw new RuntimeException("Expected p or replicates or minSuccesses");
            }
        }
    }

    public void setSuccessProbability(double p) {
        this.p.setValue(p);
    }

    public String toString() {
        return this.getName();
    }

    public Value<Double> getP() {
        return this.getParams().get("p");
    }

    public Value<Integer> getMinSuccesses() {
        return this.getParams().get("minSuccesses");
    }
}

