/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.BetaDistribution;

public class Beta
implements GenerativeDistribution1D<Double> {
    private Value<Number> alpha;
    private Value<Number> beta;
    private static final Double[] domainBounds = new Double[]{0.0, 1.0};

    public Beta(@ParameterInfo(name="alpha", description="the first shape parameter.") Value<Number> alpha, @ParameterInfo(name="beta", description="the second shape parameter.") Value<Number> beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    @GeneratorInfo(name="Beta", verbClause="has", narrativeName="Beta distribution prior", description="The beta probability distribution.")
    public RandomVariable<Double> sample() {
        BetaDistribution betaDistribution = new BetaDistribution(ValueUtils.doubleValue(this.alpha), ValueUtils.doubleValue(this.beta));
        double randomVariable = betaDistribution.sample();
        return new RandomVariable<Double>("x", Double.valueOf(randomVariable), this);
    }

    @Override
    public double logDensity(Double d) {
        BetaDistribution betaDistribution = new BetaDistribution(ValueUtils.doubleValue(this.alpha), ValueUtils.doubleValue(this.beta));
        return betaDistribution.logDensity(d.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("alpha", Beta.this.alpha);
                this.put("beta", Beta.this.beta);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("alpha")) {
            this.alpha = value;
        } else if (paramName.equals("beta")) {
            this.beta = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Double[] getDomainBounds() {
        return domainBounds;
    }
}

