/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.BinomialDistribution;

public class Binomial
implements GenerativeDistribution<Integer> {
    private Value<Double> p;
    private Value<Integer> n;

    public Binomial(@ParameterInfo(name="p", description="the probability of a success.") Value<Double> p, @ParameterInfo(name="n", description="number of trials.") Value<Integer> n) {
        this.p = p;
        this.n = n;
    }

    @Override
    @GeneratorInfo(name="Binomial", narrativeName="binomial distribution", description="The binomial distribution of x successes in n trials given probability p of success of a single trial.")
    public RandomVariable<Integer> sample() {
        BinomialDistribution binomial = new BinomialDistribution(this.n.value().intValue(), this.p.value().doubleValue());
        return new RandomVariable<Integer>(null, Integer.valueOf(binomial.sample()), this);
    }

    @Override
    public double density(Integer i) {
        BinomialDistribution binomial = new BinomialDistribution(this.n.value().intValue(), this.p.value().doubleValue());
        return binomial.probability(i.intValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("p", Binomial.this.p);
                this.put("n", Binomial.this.n);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("p")) {
            this.p = value;
        } else if (paramName.equals("n")) {
            this.n = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }
}

