/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Collections;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class Categorical
implements GenerativeDistribution<Integer> {
    Value<Double[]> probs;
    RandomGenerator random;

    public Categorical(@ParameterInfo(name="p", description="the probability distribution over integer states 1 to K.") Value<Double[]> probs) {
        this.probs = probs;
        this.random = Utils.getRandom();
    }

    @Override
    public RandomVariable<Integer> sample() {
        int i = Categorical.sample(this.probs.value(), this.random);
        return new RandomVariable<Integer>("X", Integer.valueOf(i), this);
    }

    public static int sample(Double[] p, RandomGenerator random) {
        double U = random.nextDouble();
        double sum = p[0];
        int i = 0;
        while (U > sum) {
            sum += p[i + 1].doubleValue();
            ++i;
        }
        return i;
    }

    @Override
    public Map<String, Value> getParams() {
        return Collections.singletonMap("p", this.probs);
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (!paramName.equals("p")) {
            throw new RuntimeException("Only valid parameter name is p");
        }
        this.probs = value;
    }
}

