/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.CauchyDistribution;

public class Cauchy
implements GenerativeDistribution<Double> {
    private Value<Double> mean;
    private Value<Double> scale;
    CauchyDistribution cauchyDistribution;

    public Cauchy(@ParameterInfo(name="mean", description="the mean of the Cauchy distribution.") Value<Double> mean, @ParameterInfo(name="scale", description="the scale of the Cauchy distribution.") Value<Double> scale) {
        this.mean = mean;
        if (mean == null) {
            throw new IllegalArgumentException("The mean value can't be null!");
        }
        this.scale = scale;
        if (scale == null) {
            throw new IllegalArgumentException("The scale value can't be null!");
        }
        this.constructCauchyDistribution();
    }

    @Override
    @GeneratorInfo(name="Gamma", description="The gamma probability distribution.")
    public RandomVariable<Double> sample() {
        this.constructCauchyDistribution();
        double x = this.cauchyDistribution.sample();
        return new RandomVariable<Double>("x", Double.valueOf(x), this);
    }

    @Override
    public double density(Double x) {
        return this.cauchyDistribution.density(x.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("mean", Cauchy.this.mean);
                this.put("scale", Cauchy.this.scale);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("mean")) {
            this.mean = value;
        } else if (paramName.equals("scale")) {
            this.scale = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
        this.constructCauchyDistribution();
    }

    private void constructCauchyDistribution() {
        double mean = ((Number)this.mean.value()).doubleValue();
        double sc = ((Number)this.scale.value()).doubleValue();
        this.cauchyDistribution = new CauchyDistribution(mean, sc);
    }

    public String toString() {
        return this.getName();
    }
}

