/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Collections;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;

public class Dirichlet
implements GenerativeDistribution<Double[]> {
    private Value<Number[]> concentration;

    public Dirichlet(@ParameterInfo(name="conc", narrativeName="concentration", description="the concentration parameters of a Dirichlet distribution.") Value<Number[]> concentration) {
        this.concentration = concentration;
    }

    @Override
    @GeneratorInfo(name="Dirichlet", verbClause="have", narrativeName="Dirichlet distribution prior", description="The dirichlet probability distribution.")
    public RandomVariable<Double[]> sample() {
        int i;
        Double[] dirichlet = new Double[this.concentration.value().length];
        double sum = 0.0;
        for (i = 0; i < dirichlet.length; ++i) {
            double val = Utils.randomGamma(this.concentration.value()[i].doubleValue(), 1.0);
            dirichlet[i] = val;
            sum += val;
        }
        i = 0;
        while (i < dirichlet.length) {
            Double[] doubleArray = dirichlet;
            int n = i++;
            Double.valueOf(doubleArray[n] / sum);
        }
        return new RandomVariable<Double[]>("x", dirichlet, this);
    }

    @Override
    public double density(Double[] d) {
        return 0.0;
    }

    @Override
    public Map<String, Value> getParams() {
        return Collections.singletonMap("conc", this.concentration);
    }

    public Value<Number[]> getConcentration() {
        return this.concentration;
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (!paramName.equals("conc")) {
            throw new RuntimeException("Only valid parameter name is conc");
        }
        this.concentration = value;
    }

    public String toString() {
        return this.getName();
    }
}

