/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class DiscreteUniform
implements GenerativeDistribution<Integer> {
    private Value<Integer> lower;
    private Value<Integer> upper;
    private RandomGenerator random;

    public DiscreteUniform(@ParameterInfo(name="lower", description="the lower bound (inclusive) of the uniform distribution on integers.") Value<Integer> lower, @ParameterInfo(name="upper", description="the upper bound (inclusive) of the uniform distribution on integer.") Value<Integer> upper) {
        this.lower = lower;
        this.upper = upper;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="DiscreteUniform", description="The discrete uniform distribution over integers.")
    public RandomVariable<Integer> sample() {
        int l = this.lower.value();
        int u = this.upper.value();
        int x = this.random.nextInt(u - l + 1) + l;
        return new RandomVariable<Integer>(null, Integer.valueOf(x), this);
    }

    @Override
    public double logDensity(Integer x) {
        if (x < this.lower.value() || x > this.upper.value()) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(1.0) - Math.log(this.upper.value() - this.lower.value());
    }

    @Override
    public double density(Double x) {
        if (x < (double)this.lower.value().intValue() || x > (double)this.upper.value().intValue()) {
            return 0.0;
        }
        return 1.0 / (double)(this.upper.value() - this.lower.value() + 1);
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("lower", DiscreteUniform.this.lower);
                this.put("upper", DiscreteUniform.this.upper);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("lower")) {
            this.lower = value;
        } else if (paramName.equals("upper")) {
            this.upper = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Integer> getLower() {
        return this.lower;
    }

    public Value<Integer> getUpper() {
        return this.upper;
    }
}

