/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.GammaDistribution;

public class DiscretizedGamma
implements GenerativeDistribution<Double> {
    private static final String ncatParamName = "ncat";
    private Value<Number> shape;
    private Value<Integer> ncat;
    GammaDistribution gammaDistribution;
    double[] rates;

    public DiscretizedGamma(@ParameterInfo(name="shape", description="the shape of the discretized gamma distribution.") Value<Number> shape, @ParameterInfo(name="ncat", description="the number of bins in the discretization.") Value<Integer> ncat) {
        this.shape = shape;
        if (shape == null) {
            throw new IllegalArgumentException("The shape value can't be null!");
        }
        this.ncat = ncat;
        this.constructGammaDistribution();
    }

    @Override
    @GeneratorInfo(name="DiscretizeGamma", description="The discretized gamma probability distribution with mean = 1.")
    public RandomVariable<Double> sample() {
        this.constructGammaDistribution();
        return new RandomVariable<Double>(null, Double.valueOf(this.rates[Utils.getRandom().nextInt(this.rates.length)]), this);
    }

    @Override
    public double logDensity(Double[] x) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("shape", DiscretizedGamma.this.shape);
                this.put(DiscretizedGamma.ncatParamName, DiscretizedGamma.this.ncat);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if ("shape".equals(paramName)) {
            this.shape = value;
        } else if (ncatParamName.equals(paramName)) {
            this.ncat = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
        this.constructGammaDistribution();
    }

    public Value<Number> getShape() {
        return this.shape;
    }

    public Value<Integer> getNcat() {
        return this.ncat;
    }

    public String toString() {
        return this.getName();
    }

    private void constructGammaDistribution() {
        double sh = ValueUtils.doubleValue(this.shape);
        this.gammaDistribution = new GammaDistribution(sh, 1.0 / sh);
        this.rates = new double[this.ncat.value().intValue()];
        for (int i = 0; i < this.rates.length; ++i) {
            double q = (2.0 * (double)i + 1.0) / (2.0 * (double)this.rates.length);
            this.rates[i] = this.gammaDistribution.inverseCumulativeProbability(q);
        }
    }
}

