/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Collections;
import java.util.Map;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.random.RandomGenerator;

public class Exp
implements GenerativeDistribution<Double> {
    private Value<Double> mean;
    private RandomGenerator random;

    public Exp(@ParameterInfo(name="mean", description="the mean of an exponential distribution.") Value<Double> mean) {
        this.mean = mean;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Exp", verbClause="has", narrativeName="exponential distribution prior", description="The exponential probability distribution.")
    public RandomVariable<Double> sample() {
        double x = -Math.log(this.random.nextDouble()) * this.getMean();
        return new RandomVariable<Double>("x", Double.valueOf(x), this);
    }

    @Override
    public double density(Double aDouble) {
        return 0.0;
    }

    @Override
    public Map<String, Value> getParams() {
        return Collections.singletonMap("mean", this.mean);
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (!paramName.equals("mean")) {
            throw new RuntimeException("Only valid parameter name is mean");
        }
        this.mean = value;
    }

    public double getMean() {
        if (this.mean != null) {
            return this.mean.value();
        }
        return 1.0;
    }

    public void setMean(double mean) {
        this.mean.setValue(mean);
    }

    public String toString() {
        return this.getName();
    }
}

