/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.random.RandomGenerator;

public class ExpMarkovChain
implements GenerativeDistribution<Double[]> {
    private static final String initialMeanParamName = "initialMean";
    private static final String firstValueParamName = "firstValue";
    private Value<Double> initialMean;
    private Value<Double> firstValue;
    private Value<Integer> n;
    private RandomGenerator random;

    public ExpMarkovChain(@ParameterInfo(name="initialMean", narrativeName="initial mean", description="This is the mean of the exponential from which the first value of the chain is drawn.", optional=true) Value<Double> initialMean, @ParameterInfo(name="firstValue", description="This is the value of the 1st element of the chain (X[0]).", optional=true) Value<Double> firstValue, @ParameterInfo(name="n", narrativeName="number of steps", description="the dimension of the return. Use either X[0] ~ Exp(mean=initialMean); or X[0] ~ LogNormal(meanlog, sdlog); Then X[i+1] ~ Exp(mean=X[i])") Value<Integer> n) {
        if (initialMean == null && firstValue == null || initialMean != null && firstValue != null) {
            throw new IllegalArgumentException("Require either initialMean or firstValue");
        }
        if (firstValue != null) {
            this.firstValue = firstValue;
        } else {
            this.initialMean = initialMean;
        }
        this.n = n;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="ExpMarkovChain", verbClause="have", narrativeName="smoothing prior in which each element has an exponential prior with a mean of the previous element in the chain", description="A chain of random variables. X[0] ~ Exp(mean=initialMean) or X[0] ~ LogNormal(meanlog, sdlog); X[i+1] ~ Exp(mean=X[i])")
    public RandomVariable<Double[]> sample() {
        ExponentialDistribution exp;
        Double[] result = new Double[this.n.value().intValue()];
        if (this.firstValue != null) {
            result[0] = this.firstValue.value();
        } else {
            exp = new ExponentialDistribution(this.initialMean.value().doubleValue());
            result[0] = exp.sample();
        }
        for (int i = 1; i < result.length; ++i) {
            exp = new ExponentialDistribution(result[i - 1].doubleValue());
            result[i] = exp.sample();
        }
        return new RandomVariable<Double[]>("x", result, this);
    }

    @Override
    public double logDensity(Double[] x) {
        ExponentialDistribution exp;
        double logDensity;
        if (this.firstValue != null) {
            logDensity = ((GenerativeDistribution1D)this.firstValue.getGenerator()).logDensity(x[0]);
        } else {
            exp = new ExponentialDistribution(this.initialMean.value().doubleValue());
            logDensity = exp.logDensity(x[0].doubleValue());
        }
        for (int i = 1; i < x.length; ++i) {
            exp = new ExponentialDistribution(x[i - 1].doubleValue());
            logDensity += exp.logDensity(x[i].doubleValue());
        }
        return logDensity;
    }

    @Override
    public Map<String, Value> getParams() {
        if (this.firstValue != null) {
            return new TreeMap<String, Value>(){
                {
                    this.put(ExpMarkovChain.firstValueParamName, ExpMarkovChain.this.firstValue);
                    this.put("n", ExpMarkovChain.this.n);
                }
            };
        }
        return new TreeMap<String, Value>(){
            {
                this.put(ExpMarkovChain.initialMeanParamName, ExpMarkovChain.this.initialMean);
                this.put("n", ExpMarkovChain.this.n);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals(initialMeanParamName)) {
            this.initialMean = value;
        } else if (paramName.equals(firstValueParamName)) {
            this.firstValue = value;
        } else if (paramName.equals("n")) {
            this.n = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Double> getInitialMean() {
        return this.initialMean;
    }

    public Value<Double> getFirstValue() {
        return this.firstValue;
    }

    public Value<Integer> getN() {
        return this.n;
    }
}

