/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.random.RandomGenerator;

@Deprecated
public class ExpMulti
implements GenerativeDistribution<Double[]> {
    private Value<Double> mean;
    private Value<Integer> n;
    private RandomGenerator random;

    public ExpMulti(@ParameterInfo(name="mean", description="the mean of an exponential distribution.") Value<Double> mean, @ParameterInfo(name="n", description="the number of iid exponential draws.") Value<Integer> n) {
        this.mean = mean;
        this.n = n;
        this.random = Utils.getRandom();
    }

    @Override
    @GeneratorInfo(name="Exp", description="The exponential probability distribution.")
    public RandomVariable<Double[]> sample() {
        Double[] x = new Double[this.n.value().intValue()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = -Math.log(this.random.nextDouble()) * this.getMean();
        }
        return new RandomVariable<Double[]>("x", x, this);
    }

    @Override
    public double logDensity(Double[] x) {
        ExponentialDistribution exp = new ExponentialDistribution(this.mean.value().doubleValue());
        double logP = exp.logDensity(x[0].doubleValue());
        for (int i = 1; i < x.length; ++i) {
            logP += exp.logDensity(x[i].doubleValue());
        }
        return logP;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("mean", ExpMulti.this.mean);
                this.put("n", ExpMulti.this.n);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if ("mean".equals(paramName)) {
            this.mean = value;
        } else if ("n".equals(paramName)) {
            this.n = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public double getMean() {
        if (this.mean != null) {
            return this.mean.value();
        }
        return 1.0;
    }

    public void setMean(double mean) {
        this.mean.setValue(mean);
    }

    public String toString() {
        return this.getName();
    }
}

