/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.GammaDistribution;

public class Gamma
implements GenerativeDistribution1D<Double> {
    private Value<Double> shape;
    private Value<Double> scale;
    GammaDistribution gammaDistribution;
    private static final Double[] domainBounds = new Double[]{0.0, Double.POSITIVE_INFINITY};

    public Gamma(@ParameterInfo(name="shape", description="the shape of the distribution.") Value<Double> shape, @ParameterInfo(name="scale", description="the scale of the distribution.") Value<Double> scale) {
        this.shape = shape;
        if (shape == null) {
            throw new IllegalArgumentException("The shape value can't be null!");
        }
        this.scale = scale;
        if (scale == null) {
            throw new IllegalArgumentException("The scale value can't be null!");
        }
        this.constructGammaDistribution();
    }

    @Override
    @GeneratorInfo(name="Gamma", description="The gamma probability distribution.")
    public RandomVariable<Double> sample() {
        this.constructGammaDistribution();
        double x = this.gammaDistribution.sample();
        return new RandomVariable<Double>("x", Double.valueOf(x), this);
    }

    @Override
    public double density(Double x) {
        return this.gammaDistribution.density(x.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("shape", Gamma.this.shape);
                this.put("scale", Gamma.this.scale);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals("shape")) {
            this.shape = value;
        } else if (paramName.equals("scale")) {
            this.scale = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
        this.constructGammaDistribution();
    }

    private void constructGammaDistribution() {
        double sh = ((Number)this.shape.value()).doubleValue();
        double sc = ((Number)this.scale.value()).doubleValue();
        this.gammaDistribution = new GammaDistribution(Utils.getRandom(), sh, sc);
    }

    public String toString() {
        return this.getName();
    }

    public Value<Double> getScale() {
        return this.scale;
    }

    public Value<Double> getShape() {
        return this.shape;
    }

    public Double[] getDomainBounds() {
        return domainBounds;
    }
}

