/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Collections;
import java.util.Map;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.GeometricDistribution;

public class Geometric
implements GenerativeDistribution1D<Integer> {
    private Value<Double> p;
    private static final Integer[] domainBounds = new Integer[]{0, Integer.MAX_VALUE};

    public Geometric(@ParameterInfo(name="p", description="the probability of success.") Value<Double> p) {
        this.p = p;
    }

    @Override
    @GeneratorInfo(name="Gamma", description="The probability distribution of the number of failures before the first success given a fixed probability of success p, supported on the set { 0, 1, 2, 3, ... }.")
    public RandomVariable<Integer> sample() {
        GeometricDistribution geom = new GeometricDistribution(this.p.value().doubleValue());
        return new RandomVariable<Integer>(null, Integer.valueOf(geom.sample()), this);
    }

    @Override
    public double density(Integer i) {
        GeometricDistribution geom = new GeometricDistribution(this.p.value().doubleValue());
        return geom.probability(i.intValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return Collections.singletonMap("p", this.p);
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (!paramName.equals("p")) {
            throw new RuntimeException("Only valid parameter name is p");
        }
        this.p = value;
    }

    public void setSuccessProbability(double p) {
        this.p.setValue(p);
    }

    public String toString() {
        return this.getName();
    }

    public Integer[] getDomainBounds() {
        return domainBounds;
    }
}

