/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lphy.core.distributions.Beta;
import lphy.core.narrative.Narrative;
import lphy.graphicalModel.Argument;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.Generator;
import lphy.graphicalModel.NarrativeUtils;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.VectorizedRandomVariable;
import lphy.graphicalModel.types.IntegerValue;

public class IID<T>
implements GenerativeDistribution<T[]> {
    Map<String, Value> params;
    GenerativeDistribution<T> baseDistribution;
    public static final String replicatesParamName = "replicates";

    public IID(Constructor baseDistributionConstructor, Object[] initArgs, Map<String, Value> params) {
        this.params = params;
        try {
            HashMap elementParams = new HashMap();
            params.forEach((key, value) -> {
                if (!key.equals(replicatesParamName)) {
                    elementParams.put(key, value);
                }
            });
            this.baseDistribution = (GenerativeDistribution)baseDistributionConstructor.newInstance(initArgs);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static boolean match(Constructor constructor, List<Argument> arguments, Object[] initargs, Map<String, Value> params) {
        if (!GenerativeDistribution.class.isAssignableFrom(constructor.getDeclaringClass())) {
            return false;
        }
        if (!IID.hasValidReplicatesParam(params)) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Argument argument = arguments.get(i);
            Value argValue = (Value)initargs[i];
            if (argument.name.equals(replicatesParamName)) {
                return false;
            }
            if (argValue == null && !argument.optional) {
                return false;
            }
            if (argValue == null || argument.type.isAssignableFrom(argValue.value().getClass())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasValidReplicatesParam(Map<String, Value> params) {
        Value value = params.get(replicatesParamName);
        return value != null && value.getType() == Integer.class;
    }

    public int size() {
        return (Integer)this.params.get(replicatesParamName).value();
    }

    @Override
    public String getInferenceStatement(Value value, Narrative narrative) {
        if (value instanceof VectorizedRandomVariable) {
            VectorizedRandomVariable vrv = (VectorizedRandomVariable)value;
            StringBuilder builder = new StringBuilder();
            builder.append(narrative.product("i", "0", this.getReplicatesTo(narrative)));
            GenerativeDistribution<T> generator = this.baseDistribution;
            Value v = vrv.getComponentValue(0);
            String componentStatement = generator.getInferenceStatement(v, narrative);
            componentStatement = componentStatement.replaceAll("_0", narrative.subscript("i"));
            componentStatement = componentStatement.replaceAll("_\\{0}", narrative.subscript("i"));
            builder.append(componentStatement);
            return builder.toString();
        }
        throw new RuntimeException("Expected VectorizedRandomVariable!");
    }

    @Override
    public String getInferenceNarrative(Value value, boolean unique, Narrative narrative) {
        if (value instanceof VectorizedRandomVariable) {
            VectorizedRandomVariable vrv = (VectorizedRandomVariable)value;
            StringBuilder builder = new StringBuilder();
            GenerativeDistribution<T> generator = this.baseDistribution;
            Value v = vrv.getComponentValue(0);
            String inferenceNarrative = generator.getInferenceNarrative(v, unique, narrative);
            if ((inferenceNarrative = inferenceNarrative.replace(narrative.subscript("0"), narrative.subscript("i"))).endsWith(".")) {
                inferenceNarrative = inferenceNarrative.substring(0, inferenceNarrative.lastIndexOf(46));
            }
            builder.append(inferenceNarrative);
            builder.append(this.getReplicatesNarrativeClause(narrative));
            return builder.toString();
        }
        throw new RuntimeException("Expected VectorizedRandomVariable!");
    }

    public String getReplicatesTo(Narrative narrative) {
        Value replicatesValue = this.getParams().get(replicatesParamName);
        Object replicateToString = "";
        replicateToString = replicatesValue.isAnonymous() ? "" + (this.size() - 1) : narrative.getId(replicatesValue, false) + " - 1";
        return replicateToString;
    }

    public String getReplicatesNarrativeClause(Narrative narrative) {
        return ", for i in 0 to " + this.getReplicatesTo(narrative) + ".";
    }

    @Override
    public String getNarrativeName(Value value) {
        String paramName = this.getParamName(value);
        if (paramName.equals(replicatesParamName)) {
            return "number of replicates";
        }
        return this.baseDistribution.getNarrativeName(paramName);
    }

    public GenerativeDistribution<T> getBaseDistribution() {
        return this.baseDistribution;
    }

    @Override
    public RandomVariable<T[]> sample() {
        int size = this.size();
        ArrayList<RandomVariable> componentVariables = new ArrayList<RandomVariable>();
        for (int i = 0; i < size; ++i) {
            componentVariables.add(this.baseDistribution.sample());
        }
        return new VectorizedRandomVariable(null, (List<RandomVariable>)componentVariables, this);
    }

    @Override
    public Map<String, Value> getParams() {
        return this.params;
    }

    @Override
    public void setParam(String paramName, Value value) {
        this.params.put(paramName, value);
        if (!paramName.equals(replicatesParamName)) {
            this.baseDistribution.setParam(paramName, value);
        }
    }

    @Override
    public String getTypeName() {
        if (this.size() > 1) {
            return "vector of " + NarrativeUtils.pluralize(this.baseDistribution.getTypeName());
        }
        return Generator.getReturnType(this.getClass()).getSimpleName();
    }

    @Override
    public String getRichDescription(int index) {
        return this.baseDistribution.getRichDescription(index);
    }

    @Override
    public String getName() {
        return this.baseDistribution.getName();
    }

    public static void main(String[] args) {
        Value<Number> a = new Value<Number>("alpha", 2.0);
        Value<Number> b = new Value<Number>("beta", 2.0);
        Beta beta = new Beta(a, b);
        HashMap<String, Value> params = new HashMap<String, Value>();
        params.put("alpha", new Value<Double>("alpha", 2.0));
        params.put("beta", new Value<Double>("beta", 2.0));
        params.put(replicatesParamName, new IntegerValue(null, 3));
        Object[] initArgs = new Object[]{params.get("alpha"), params.get("beta")};
        Constructor<?> constructor = beta.getClass().getConstructors()[0];
        IID v = new IID(constructor, initArgs, params);
        RandomVariable<T[]> rbeta = v.sample();
        System.out.println(Arrays.toString((Object[])rbeta.value()));
    }

    public Value<Integer> getReplicates() {
        return this.getParams().get(replicatesParamName);
    }
}

