/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.GammaDistribution;

public class InverseGamma
implements GenerativeDistribution1D<Double> {
    private Value<Number> alpha;
    private Value<Number> beta;
    GammaDistribution gammaDistribution;
    private static final Double[] domainBounds = new Double[]{0.0, Double.POSITIVE_INFINITY};

    public InverseGamma(@ParameterInfo(name="alpha", description="the alpha parameter of inverse gamma.") Value<Number> alpha, @ParameterInfo(name="beta", description="the beta parameter of inverse gamma.") Value<Number> beta) {
        this.alpha = alpha;
        if (alpha == null) {
            throw new IllegalArgumentException("The alpha value can't be null!");
        }
        this.beta = beta;
        if (beta == null) {
            throw new IllegalArgumentException("The beta value can't be null!");
        }
        this.constructGammaDistribution();
    }

    @Override
    @GeneratorInfo(name="InverseGamma", description="The inverse-gamma probability distribution.")
    public RandomVariable<Double> sample() {
        this.constructGammaDistribution();
        double x = 1.0 / this.gammaDistribution.sample();
        return new RandomVariable<Double>(null, Double.valueOf(x), this);
    }

    @Override
    public double density(Double x) {
        return this.gammaDistribution.density(x.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("alpha", InverseGamma.this.alpha);
                this.put("beta", InverseGamma.this.beta);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if ("alpha".equals(paramName)) {
            this.alpha = value;
        } else if ("beta".equals(paramName)) {
            this.beta = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
        this.constructGammaDistribution();
    }

    private void constructGammaDistribution() {
        double a = ValueUtils.doubleValue(this.alpha);
        double b = ValueUtils.doubleValue(this.beta);
        this.gammaDistribution = new GammaDistribution(a, 1.0 / b);
    }

    public String toString() {
        return this.getName();
    }

    public Value<Number> getBeta() {
        return this.beta;
    }

    public Value<Number> getAlpha() {
        return this.alpha;
    }

    public Double[] getDomainBounds() {
        return domainBounds;
    }
}

