/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.LogNormalDistribution;

public class LogNormal
implements GenerativeDistribution1D<Double> {
    public static final String meanLogParamName = "meanlog";
    public static final String sdLogParamName = "sdlog";
    private Value<Number> M;
    private Value<Number> S;
    LogNormalDistribution logNormalDistribution;
    private static final Double[] domainBounds = new Double[]{0.0, Double.POSITIVE_INFINITY};

    public LogNormal(@ParameterInfo(name="meanlog", narrativeName="mean in log space", description="the mean of the distribution on the log scale.") Value<Number> M, @ParameterInfo(name="sdlog", narrativeName="standard deviation in log space", description="the standard deviation of the distribution on the log scale.") Value<Number> S) {
        this.M = M;
        this.S = S;
    }

    @Override
    @GeneratorInfo(name="LogNormal", verbClause="has", narrativeName="log-normal prior", description="The log-normal probability distribution.")
    public RandomVariable<Double> sample() {
        this.logNormalDistribution = new LogNormalDistribution(ValueUtils.doubleValue(this.M), ValueUtils.doubleValue(this.S));
        return new RandomVariable<Double>(null, Double.valueOf(this.logNormalDistribution.sample()), this);
    }

    @Override
    public double logDensity(Double x) {
        return this.logNormalDistribution.logDensity(x.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put(LogNormal.meanLogParamName, LogNormal.this.M);
                this.put(LogNormal.sdLogParamName, LogNormal.this.S);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if (paramName.equals(meanLogParamName)) {
            this.M = value;
        } else if (paramName.equals(sdLogParamName)) {
            this.S = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Number> getMeanLog() {
        return this.M;
    }

    public Value<Number> getSDLog() {
        return this.S;
    }

    public Double[] getDomainBounds() {
        return domainBounds;
    }
}

