/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.graphicalModel.GenerativeDistribution;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import lphy.graphicalModel.ValueUtils;
import org.apache.commons.math3.distribution.LogNormalDistribution;

@Deprecated
public class LogNormalMulti
implements GenerativeDistribution<Double[]> {
    private Value<Number> M;
    private Value<Number> S;
    private Value<Integer> n;
    LogNormalDistribution logNormalDistribution;

    public LogNormalMulti(@ParameterInfo(name="meanlog", narrativeName="mean in log space", description="the mean of the distribution on the log scale.") Value<Number> M, @ParameterInfo(name="sdlog", narrativeName="standard deviation in log space", description="the standard deviation of the distribution on the log scale.") Value<Number> S, @ParameterInfo(name="n", narrativeName="dimension", description="the dimension of the return.") Value<Integer> n) {
        this.M = M;
        this.S = S;
        this.n = n;
    }

    @Override
    @GeneratorInfo(name="LogNormal", narrativeName="i.i.d. log-normal prior", description="The log-normal probability distribution.")
    public RandomVariable<Double[]> sample() {
        this.logNormalDistribution = new LogNormalDistribution(ValueUtils.doubleValue(this.M), ValueUtils.doubleValue(this.S));
        Double[] result = new Double[this.n.value().intValue()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.logNormalDistribution.sample();
        }
        return new RandomVariable<Double[]>(null, result, this);
    }

    @Override
    public double logDensity(Double[] x) {
        double logDensity = 0.0;
        for (Double aDouble : x) {
            logDensity += this.logNormalDistribution.logDensity(aDouble.doubleValue());
        }
        return logDensity;
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("meanlog", LogNormalMulti.this.M);
                this.put("sdlog", LogNormalMulti.this.S);
                this.put("n", LogNormalMulti.this.n);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        switch (paramName) {
            case "meanlog": {
                this.M = value;
                break;
            }
            case "sdlog": {
                this.S = value;
                break;
            }
            case "n": {
                this.n = value;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised parameter name: " + paramName);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Number> getMeanLog() {
        return this.M;
    }

    public Value<Number> getSDLog() {
        return this.S;
    }
}

