/*
 * Decompiled with CFR 0.152.
 */
package lphy.core.distributions;

import java.util.Map;
import java.util.TreeMap;
import lphy.core.distributions.Utils;
import lphy.graphicalModel.GenerativeDistribution1D;
import lphy.graphicalModel.GeneratorInfo;
import lphy.graphicalModel.ParameterInfo;
import lphy.graphicalModel.RandomVariable;
import lphy.graphicalModel.Value;
import org.apache.commons.math3.distribution.NormalDistribution;

public class Normal
implements GenerativeDistribution1D<Double> {
    private Value<Double> mean;
    private Value<Double> sd;
    NormalDistribution normalDistribution;
    private static final Double[] domainBounds = new Double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};

    public Normal(@ParameterInfo(name="mean", description="the mean of the distribution.") Value<Double> mean, @ParameterInfo(name="sd", narrativeName="standard deviation", description="the standard deviation of the distribution.") Value<Double> sd) {
        this.mean = mean;
        if (mean == null) {
            throw new IllegalArgumentException("The mean value can't be null!");
        }
        this.sd = sd;
        if (sd == null) {
            throw new IllegalArgumentException("The sd value can't be null!");
        }
    }

    @Override
    @GeneratorInfo(name="Normal", verbClause="has", narrativeName="normal prior", description="The normal probability distribution.")
    public RandomVariable<Double> sample() {
        double d = ((Number)this.mean.value()).doubleValue();
        this.normalDistribution = new NormalDistribution(Utils.getRandom(), d, this.sd.value().doubleValue());
        double x = this.normalDistribution.sample();
        return new RandomVariable<Double>("x", Double.valueOf(x), this);
    }

    @Override
    public double density(Double x) {
        return this.normalDistribution.density(x.doubleValue());
    }

    @Override
    public Map<String, Value> getParams() {
        return new TreeMap<String, Value>(){
            {
                this.put("mean", Normal.this.mean);
                this.put("sd", Normal.this.sd);
            }
        };
    }

    @Override
    public void setParam(String paramName, Value value) {
        if ("mean".equals(paramName)) {
            this.mean = value;
        } else if ("sd".equals(paramName)) {
            this.sd = value;
        } else {
            throw new RuntimeException("Unrecognised parameter name: " + paramName);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Value<Double> getMean() {
        return this.mean;
    }

    public Value<Double> getSd() {
        return this.sd;
    }

    public Double[] getDomainBounds() {
        return domainBounds;
    }
}

